package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import okhttp3.HttpUrl;

import java.net.URI;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@EqualsAndHashCode
@ToString
public class Endpoint {

    private String host;

    private int port;

    public HttpUrl url(final String path) {
        return HttpUrl.get(URI.create(String.format("http://%s:%d%s", host, port, path)));
    }

    public HttpUrl secureUrl(final String path) {
        return HttpUrl.get(URI.create(String.format("https://%s:%d%s", host, port, path)));
    }
}
