/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.HttpGetCommand;
import com.phonepe.sdk.javasdk.http.HttpPostCommand;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.transaction.init.models.Base64Request;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import java.util.List;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionClient {
    private static final Logger log = LoggerFactory.getLogger(TransactionClient.class);
    private final ObjectMapper objectMapper;
    private final OkHttpClient client;
    private final Endpoint endpoint;
    private final HystrixConfig hystrixConfig;

    public TransactionClient(HttpClientConfig httpClientConfig, ObjectMapper objectMapper, OkHttpClient okHttpClient, HystrixConfig hystrixConfig) {
        this.objectMapper = objectMapper;
        this.endpoint = httpClientConfig.getEndpoint();
        this.client = okHttpClient;
        this.hystrixConfig = hystrixConfig;
    }

    public InitResponse initTransaction(Base64Request base64Request, List<HttpHeaderPair> httpHeaders, String url) throws Exception {
        try {
            Consumer initResponseConsumer = TransactionClient.handleNonSuccessServiceCall(log, "initTransaction");
            PhonePeHttpResponse phonePeHttpResponse = (PhonePeHttpResponse)HttpPostCommand.builder().url(url).client(this.client).mapper(this.objectMapper).endpoint(this.endpoint).command("transactionInit").responseTypeReference(new TypeReference<PhonePeHttpResponse<InitResponse>>(){}).headers(httpHeaders).httpRequest(new PhonePeHttpRequest<Base64Request>(base64Request)).nonSuccessResponseConsumer(initResponseConsumer).hystrixConfig(this.hystrixConfig).build().executeTracked(TransactionClient.class);
            return (InitResponse)phonePeHttpResponse.getData();
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe transaction init API", (Throwable)e);
            throw new PhonePeException();
        }
    }

    public PhonePeHttpResponse<TransactionStatusResponse> getTransactionStatus(List<HttpHeaderPair> httpHeaders, String url) throws Exception {
        try {
            Consumer transactionResponseConsumer = TransactionClient.handleNonSuccessServiceCall(log, "transactionStatus");
            return (PhonePeHttpResponse)HttpGetCommand.builder().url(url).client(this.client).mapper(this.objectMapper).endpoint(this.endpoint).command("transactionStatus").responseTypeReference(new TypeReference<PhonePeHttpResponse<TransactionStatusResponse>>(){}).headers(httpHeaders).nonSuccessResponseConsumer(transactionResponseConsumer).hystrixConfig(this.hystrixConfig).build().executeTracked(TransactionClient.class);
        }
        catch (Exception e) {
            log.error("Error in calling PhonePe transaction status API", (Throwable)e);
            throw new PhonePeException();
        }
    }

    public static <T> Consumer<ExtractedResponse, T> handleNonSuccessServiceCall(final Logger log, final String serviceName) {
        return new Consumer<ExtractedResponse, T>(){

            @Override
            public T consume(ExtractedResponse extractedResponse) throws Exception {
                int code = extractedResponse.getCode();
                byte[] body = extractedResponse.getBody();
                log.error("Error while calling {} service code:{}, response:{}", new Object[]{serviceName, code, new String(body)});
                throw new PhonePeException();
            }
        };
    }
}

