/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.callback;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandler.class);
    private TransactionStatusChecker transactionStatusChecker;
    private MerchantConfig merchantConfig;

    public CallbackHandler(TransactionStatusChecker transactionStatusChecker, MerchantConfig merchantConfig) {
        this.transactionStatusChecker = transactionStatusChecker;
        this.merchantConfig = merchantConfig;
    }

    public StatusResponse handleCallback(String responseReceived, String checksum) {
        StatusResponse statusResponse = null;
        Preconditions.checkNotNull((Object)responseReceived);
        Preconditions.checkNotNull((Object)checksum);
        try {
            String responseBody = ChecksumUtils.decodeBase64(responseReceived);
            PhonePeHttpResponse transactionStatusResponse = (PhonePeHttpResponse)new ObjectMapper().readValue(responseBody, (TypeReference)new TypeReference<PhonePeHttpResponse<TransactionStatusResponse>>(){});
            int keyIndex = Integer.parseInt(checksum.substring(checksum.lastIndexOf(35) + 1));
            TransactionStatusResponse statusResponseData = (TransactionStatusResponse)transactionStatusResponse.getData();
            String merchantId = statusResponseData.getMerchantId();
            Long callbackAmount = statusResponseData.getAmount();
            if (!this.isValidChecksum(responseReceived, checksum, keyIndex) || !this.isValidMerchantId(merchantId)) {
                throw new PhonePeException();
            }
            String transactionId = ((TransactionStatusResponse)transactionStatusResponse.getData()).getTransactionId();
            statusResponse = this.transactionStatusChecker.checkTransactionStatus(transactionId, keyIndex);
            if (!this.isValidTransactionAmount(callbackAmount, statusResponse.getAmount())) {
                throw new PhonePeException();
            }
        }
        catch (Exception ex) {
            log.error("Exception occurred while performing transaction status check");
        }
        return statusResponse;
    }

    private boolean isValidMerchantId(String merchantId) {
        return this.merchantConfig.getMerchantId().equals(merchantId);
    }

    private boolean isValidChecksum(String responseBody, String checksum, int keyIndex) {
        try {
            String apiKey = this.getAPIKeyFromIndex(1);
            String generatedChecksum = ChecksumUtils.generateChecksumBody(responseBody, "", apiKey);
            return checksum.equalsIgnoreCase(generatedChecksum);
        }
        catch (Exception ex) {
            System.out.println("Exception occured");
            return false;
        }
    }

    private boolean isValidTransactionAmount(Long callbackAmount, Long statusResponseAmount) {
        return callbackAmount.equals(statusResponseAmount);
    }

    private String getAPIKeyFromIndex(int keyIndex) throws Exception {
        for (APIKeyConfig apiKey : this.merchantConfig.getApiKeys()) {
            if (apiKey.getKeyIndex() != keyIndex) continue;
            return apiKey.getKeyValue();
        }
        throw new PhonePeException();
    }

    public static CallbackHandlerBuilder builder() {
        return new CallbackHandlerBuilder();
    }

    public static class CallbackHandlerBuilder {
        private TransactionStatusChecker transactionStatusChecker;
        private MerchantConfig merchantConfig;

        CallbackHandlerBuilder() {
        }

        public CallbackHandlerBuilder transactionStatusChecker(TransactionStatusChecker transactionStatusChecker) {
            this.transactionStatusChecker = transactionStatusChecker;
            return this;
        }

        public CallbackHandlerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public CallbackHandler build() {
            return new CallbackHandler(this.transactionStatusChecker, this.merchantConfig);
        }

        public String toString() {
            return "CallbackHandler.CallbackHandlerBuilder(transactionStatusChecker=" + this.transactionStatusChecker + ", merchantConfig=" + this.merchantConfig + ")";
        }
    }
}

