package com.phonepe.sdk.javasdk.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;


@Slf4j
public class ChecksumUtils {

    private static final String SEPARATOR_VaLUE = "###";

    public static String generateChecksumHeader(final String checksumBody, final int apiKeyIndex){
        return checksumBody.concat(SEPARATOR_VaLUE).concat(Integer.toString(apiKeyIndex));
    }

    public static String generateChecksumBody(final String b64RequestBody, final String url, final String apiKey){
        String hex = (StringUtils.isNotBlank(b64RequestBody) ? b64RequestBody : "").concat(url).concat(apiKey);
        return DigestUtils.sha256Hex(hex);
    }
}
