package com.phonepe.sdk.javasdk.utils;

import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class KeyUtils {

    public static int getKeyIndexFromChecksum(final String checksumString){
        return Integer.parseInt(checksumString.substring(checksumString.lastIndexOf('#')+1));
    }

    public static String getAPIKeyFromIndex(List<APIKeyConfig> apiKeys, int keyIndex) throws PhonePeException {
        for(APIKeyConfig apiKey : apiKeys){
            if(apiKey.getKeyIndex() == keyIndex)
                return apiKey.getKeyValue();
        }
        throw new PhonePeException("Key not found with given index for the merchant in the config");
    }
}
