package com.phonepe.sdk.javasdk.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;

@Slf4j
public class Base64Utils {

    public static String decodeBase64(final String encodedString) {
        return org.apache.commons.codec.binary.StringUtils
                .newStringUtf8(Base64.decodeBase64(encodedString));
    }

    public static String encodeBase64(final String requestString) {
        return org.apache.commons.codec.binary.StringUtils
                .newStringUtf8(Base64.encodeBase64(requestString.getBytes()));
    }

    public static <T> Base64Request getBase64Request(final T requestBody) throws Exception{
        final String jsonBody = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(requestBody);
        final String b64RequestBody = encodeBase64(jsonBody);
        return Base64Request.builder()
                            .request(b64RequestBody)
                            .build();
    }
}
