/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.transaction.init.InitRequestDecorator;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantConstraints;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountConstraintsDecorator
extends InitRequestDecorator {
    private static final Logger log = LoggerFactory.getLogger(AccountConstraintsDecorator.class);
    private List<AllowedAccountConstraint> allowedAccountConstraints;

    public AccountConstraintsDecorator(TransactionInitComponent transactionInitComponent, List<AllowedAccountConstraint> allowedAccountConstraints) {
        super(transactionInitComponent);
        this.allowedAccountConstraints = allowedAccountConstraints;
    }

    @Override
    public InitRequest getInitRequest(String merchantId, String transactionId, Long amount) {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest(merchantId, transactionId, amount);
        MerchantContext merchantContext = initRequest.getMerchantContext();
        MerchantConstraints merchantConstraints = MerchantConstraints.builder().account(this.allowedAccountConstraints).build();
        if (merchantContext != null) {
            merchantContext.setConstraints(merchantConstraints);
        } else {
            merchantContext = MerchantContext.builder().constraints(merchantConstraints).build();
        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }

    public static AccountConstraintsDecoratorBuilder builder() {
        return new AccountConstraintsDecoratorBuilder();
    }

    public static class AccountConstraintsDecoratorBuilder {
        private TransactionInitComponent transactionInitComponent;
        private List<AllowedAccountConstraint> allowedAccountConstraints;

        AccountConstraintsDecoratorBuilder() {
        }

        public AccountConstraintsDecoratorBuilder transactionInitComponent(TransactionInitComponent transactionInitComponent) {
            this.transactionInitComponent = transactionInitComponent;
            return this;
        }

        public AccountConstraintsDecoratorBuilder allowedAccountConstraints(List<AllowedAccountConstraint> allowedAccountConstraints) {
            this.allowedAccountConstraints = allowedAccountConstraints;
            return this;
        }

        public AccountConstraintsDecorator build() {
            return new AccountConstraintsDecorator(this.transactionInitComponent, this.allowedAccountConstraints);
        }

        public String toString() {
            return "AccountConstraintsDecorator.AccountConstraintsDecoratorBuilder(transactionInitComponent=" + this.transactionInitComponent + ", allowedAccountConstraints=" + this.allowedAccountConstraints + ")";
        }
    }
}

