/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.AccountConstraintsDecorator;
import com.phonepe.sdk.javasdk.transaction.init.BaseTransactionInit;
import com.phonepe.sdk.javasdk.transaction.init.OfferInitDecorator;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import com.phonepe.sdk.javasdk.utils.Base64Utils;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionInitiator {
    private static final Logger log = LoggerFactory.getLogger(TransactionInitiator.class);
    private TransactionClient transactionClient;
    private InitConfig initConfig;
    private MerchantConfig merchantConfig;

    public TransactionInitiator(TransactionClient transactionClient, InitConfig initConfig, MerchantConfig merchantConfig) {
        this.transactionClient = transactionClient;
        this.initConfig = initConfig;
        this.merchantConfig = merchantConfig;
    }

    public InitResponse initiateTransaction(String transactionId, Long amount, String merchantOrderId, String merchantUserId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callbackMode, String callbackURL, int keyIndex) throws PhonePeException {
        TransactionInitComponent transactionInitComponent = new BaseTransactionInit();
        if (CollectionUtils.isNotEmpty(offerTags)) {
            transactionInitComponent = new OfferInitDecorator(transactionInitComponent, offerTags);
        }
        if (CollectionUtils.isNotEmpty(allowedAccountConstraints)) {
            transactionInitComponent = new AccountConstraintsDecorator(transactionInitComponent, allowedAccountConstraints);
        }
        InitRequest initRequest = transactionInitComponent.getInitRequest(this.merchantConfig.getMerchantId(), transactionId, amount);
        return this.initiateTransaction(initRequest, redirectMode, redirectURL, callbackMode, callbackURL, keyIndex);
    }

    private InitResponse initiateTransaction(InitRequest initRequest, String redirectMode, String redirectURL, String callMode, String callbackURL, int keyIndex) throws PhonePeException {
        try {
            Base64Request base64Request = Base64Utils.getBase64Request(initRequest);
            String apiURL = this.getAPIURL();
            String apiKey = this.getAPIKeyFromIndex(keyIndex);
            String checksumBody = ChecksumUtils.generateChecksumBody(base64Request.getRequest(), apiURL, apiKey);
            String checksumHeader = ChecksumUtils.generateChecksumHeader(checksumBody, keyIndex);
            List<HttpHeaderPair> httpHeaders = this.getHttpHeaders(checksumHeader, this.merchantConfig.getProviderId(), redirectURL, redirectMode, callbackURL, callMode);
            return this.performTransactionInit(base64Request, httpHeaders, apiURL);
        }
        catch (Exception ex) {
            log.error("Exception occurred in while initiating transactions");
            throw new PhonePeException(ex.getMessage(), ex);
        }
    }

    protected abstract InitRequest buildInitRequest(String var1, String var2, String var3, Long var4, String var5);

    private InitResponse performTransactionInit(Base64Request base64Request, List<HttpHeaderPair> httpHeaders, String apiURL) throws PhonePeException {
        try {
            return this.transactionClient.initTransaction(base64Request, httpHeaders, apiURL);
        }
        catch (Exception ex) {
            log.error("Exception occurred");
            throw new PhonePeException("Could not perform transaction Initiation");
        }
    }

    private String getAPIURL() {
        return String.format("/%s/debit", this.initConfig.getApiVersion().getApiVersion());
    }

    private List<HttpHeaderPair> getHttpHeaders(String checksumHeader, String providerId, String redirectURL, String redirectMode, String callbackURL, String callMode) {
        ArrayList<HttpHeaderPair> headerPairs = new ArrayList<HttpHeaderPair>();
        HttpHeaderPair checksumHeaderPair = HttpUtils.getHeaderPair("X-VERIFY", checksumHeader);
        headerPairs.add(checksumHeaderPair);
        HttpHeaderPair contentTypeHeaderPair = HttpUtils.getContentTypeHeaderPair();
        headerPairs.add(contentTypeHeaderPair);
        if (StringUtils.isNotEmpty((CharSequence)providerId)) {
            HttpHeaderPair providerIdHeader = HttpUtils.getHeaderPair("X-PROVIDER-ID", providerId);
            headerPairs.add(providerIdHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectURL)) {
            HttpHeaderPair redirectURLHeader = HttpUtils.getHeaderPair("X-REDIRECT-URL", redirectURL);
            headerPairs.add(redirectURLHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectMode)) {
            HttpHeaderPair redirectModeHeader = HttpUtils.getHeaderPair("X-REDIRECT-MODE", redirectMode);
            headerPairs.add(redirectModeHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)callbackURL)) {
            HttpHeaderPair callbackURLHeader = HttpUtils.getHeaderPair("X-CALLBACK-URL", callbackURL);
            headerPairs.add(callbackURLHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)callMode)) {
            HttpHeaderPair callbackModeHeader = HttpUtils.getHeaderPair("X-CALL-MODE", callMode);
            headerPairs.add(callbackModeHeader);
        }
        return headerPairs;
    }

    private String getAPIKeyFromIndex(int keyIndex) throws Exception {
        for (APIKeyConfig apiKey : this.merchantConfig.getApiKeys()) {
            if (apiKey.getKeyIndex() != keyIndex) continue;
            return apiKey.getKeyValue();
        }
        throw new PhonePeException();
    }
}

