/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.SDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.http.PhonePeException;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import java.util.List;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;

    public PhonePeClient(SDKConfig sdkConfig) {
        Preconditions.checkNotNull((Object)sdkConfig);
        this.init(sdkConfig);
    }

    public void init(SDKConfig sdkConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpClientConfig httpClientConfig = sdkConfig.getHttpClientConfig();
        StatusConfig statusConfig = sdkConfig.getStatusConfig();
        MerchantConfig merchantConfig = sdkConfig.getMerchantConfig();
        InitConfig initConfig = sdkConfig.getInitConfig();
        HystrixConfig hystrixConfig = sdkConfig.getHystrixConfig();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig);
        TransactionClient transactionClient = new TransactionClient(httpClientConfig, objectMapper, client, hystrixConfig);
        this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).build();
        this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
        this.transactionInitiator = WebTransactionInitiator.builder().initConfig(initConfig).merchantConfig(merchantConfig).transactionClient(transactionClient).build();
    }

    public InitResponse initTransaction(String transactionId, Long amount) throws PhonePeException {
        return this.initTransaction(transactionId, amount, null, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags) throws PhonePeException {
        return this.initTransaction(transactionId, amount, offerTags, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeException {
        return this.initTransaction(transactionId, amount, null, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeException {
        return this.initTransaction(transactionId, amount, "", "", "", "", "", "", "", offerTags, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeException {
        return this.initTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, offerTags, allowedAccountConstraints, "", "", "", "");
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callbackURL, String callMode) throws PhonePeException {
        return this.initTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, 1);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callMode, String callbackURL, int keyIndex) throws PhonePeException {
        return this.transactionInitiator.initiateTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, keyIndex);
    }

    public StatusResponse handleCallback(String responseReceived, String checksum) throws PhonePeException {
        return this.callbackHandler.handleCallback(responseReceived, checksum);
    }

    public StatusResponse checkTransactionStatus(String transactionId) {
        return this.statusChecker.checkTransactionStatus(transactionId);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public static class PhonePeClientBuilder {
        private SDKConfig sdkConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder sdkConfig(SDKConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public PhonePeClient build() {
            return new PhonePeClient(this.sdkConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(sdkConfig=" + this.sdkConfig + ")";
        }
    }
}

