package com.phonepe.sdk.javasdk.transaction.checksum;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion.APIVersionVisitor;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.BodyChecksumPayload;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumPayload;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ParamsChecksumPayload;

public class ChecksumPayloadFactory implements APIVersionVisitor<ChecksumPayload> {

    @Override
    public ChecksumPayload visitV1() {
        return ParamsChecksumPayload
                .builder().build();
    }

    @Override
    public ChecksumPayload visitV2() {
        return ParamsChecksumPayload.builder().build();
    }

    @Override
    public ChecksumPayload visitV3() {
        return BodyChecksumPayload.builder().build();
    }

    @Override
    public ChecksumPayload visitV4() {
        return BodyChecksumPayload.builder().build();
    }
}
