package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;

import java.util.List;

@Data
@NoArgsConstructor
@Builder
public class BodyChecksumPayload implements ChecksumPayload{

    @Override
    public String getChecksumPayload(PhonePeHttpRequest<?> data,
                                     String apiURL,
                                     List<String> otherParams) throws Exception{
        StringBuilder checksumPayload = new StringBuilder();
        if(ObjectUtils.isNotEmpty(data)){
            PhonePeHttpRequest<Base64Request> value = (PhonePeHttpRequest<Base64Request>) data;
            checksumPayload.append(value.getData().getRequest());
        }
        checksumPayload.append(apiURL);
        return checksumPayload.toString();
    }
}
