/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.enums.InitType;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumPayload;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;

public class TransactionInitiatorFactory
implements InitType.InitTypeVisitor<TransactionInitiator> {
    private MerchantConfig merchantConfig;
    private InitConfig initConfig;
    private TransactionClient transactionClient;
    private ChecksumPayload checksumPayload;
    private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

    @Override
    public TransactionInitiator visitWeb() {
        return WebTransactionInitiator.builder().phonePeHttpRequestCreator(this.phonePeHttpRequestCreator).checksumPayload(this.checksumPayload).transactionClient(this.transactionClient).merchantConfig(this.merchantConfig).initConfig(this.initConfig).build();
    }

    @Override
    public TransactionInitiator visitIntent() {
        return null;
    }

    public static TransactionInitiatorFactoryBuilder builder() {
        return new TransactionInitiatorFactoryBuilder();
    }

    public MerchantConfig getMerchantConfig() {
        return this.merchantConfig;
    }

    public InitConfig getInitConfig() {
        return this.initConfig;
    }

    public TransactionClient getTransactionClient() {
        return this.transactionClient;
    }

    public ChecksumPayload getChecksumPayload() {
        return this.checksumPayload;
    }

    public PhonePeHttpRequestCreator<InitRequest> getPhonePeHttpRequestCreator() {
        return this.phonePeHttpRequestCreator;
    }

    public void setMerchantConfig(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    public void setInitConfig(InitConfig initConfig) {
        this.initConfig = initConfig;
    }

    public void setTransactionClient(TransactionClient transactionClient) {
        this.transactionClient = transactionClient;
    }

    public void setChecksumPayload(ChecksumPayload checksumPayload) {
        this.checksumPayload = checksumPayload;
    }

    public void setPhonePeHttpRequestCreator(PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionInitiatorFactory)) {
            return false;
        }
        TransactionInitiatorFactory other = (TransactionInitiatorFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MerchantConfig this$merchantConfig = this.getMerchantConfig();
        MerchantConfig other$merchantConfig = other.getMerchantConfig();
        if (this$merchantConfig == null ? other$merchantConfig != null : !((Object)this$merchantConfig).equals(other$merchantConfig)) {
            return false;
        }
        InitConfig this$initConfig = this.getInitConfig();
        InitConfig other$initConfig = other.getInitConfig();
        if (this$initConfig == null ? other$initConfig != null : !((Object)this$initConfig).equals(other$initConfig)) {
            return false;
        }
        TransactionClient this$transactionClient = this.getTransactionClient();
        TransactionClient other$transactionClient = other.getTransactionClient();
        if (this$transactionClient == null ? other$transactionClient != null : !this$transactionClient.equals(other$transactionClient)) {
            return false;
        }
        ChecksumPayload this$checksumPayload = this.getChecksumPayload();
        ChecksumPayload other$checksumPayload = other.getChecksumPayload();
        if (this$checksumPayload == null ? other$checksumPayload != null : !this$checksumPayload.equals(other$checksumPayload)) {
            return false;
        }
        PhonePeHttpRequestCreator<InitRequest> this$phonePeHttpRequestCreator = this.getPhonePeHttpRequestCreator();
        PhonePeHttpRequestCreator<InitRequest> other$phonePeHttpRequestCreator = other.getPhonePeHttpRequestCreator();
        return !(this$phonePeHttpRequestCreator == null ? other$phonePeHttpRequestCreator != null : !this$phonePeHttpRequestCreator.equals(other$phonePeHttpRequestCreator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionInitiatorFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MerchantConfig $merchantConfig = this.getMerchantConfig();
        result = result * 59 + ($merchantConfig == null ? 43 : ((Object)$merchantConfig).hashCode());
        InitConfig $initConfig = this.getInitConfig();
        result = result * 59 + ($initConfig == null ? 43 : ((Object)$initConfig).hashCode());
        TransactionClient $transactionClient = this.getTransactionClient();
        result = result * 59 + ($transactionClient == null ? 43 : $transactionClient.hashCode());
        ChecksumPayload $checksumPayload = this.getChecksumPayload();
        result = result * 59 + ($checksumPayload == null ? 43 : $checksumPayload.hashCode());
        PhonePeHttpRequestCreator<InitRequest> $phonePeHttpRequestCreator = this.getPhonePeHttpRequestCreator();
        result = result * 59 + ($phonePeHttpRequestCreator == null ? 43 : $phonePeHttpRequestCreator.hashCode());
        return result;
    }

    public String toString() {
        return "TransactionInitiatorFactory(merchantConfig=" + this.getMerchantConfig() + ", initConfig=" + this.getInitConfig() + ", transactionClient=" + this.getTransactionClient() + ", checksumPayload=" + this.getChecksumPayload() + ", phonePeHttpRequestCreator=" + this.getPhonePeHttpRequestCreator() + ")";
    }

    public TransactionInitiatorFactory() {
    }

    public TransactionInitiatorFactory(MerchantConfig merchantConfig, InitConfig initConfig, TransactionClient transactionClient, ChecksumPayload checksumPayload, PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.merchantConfig = merchantConfig;
        this.initConfig = initConfig;
        this.transactionClient = transactionClient;
        this.checksumPayload = checksumPayload;
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
    }

    public static class TransactionInitiatorFactoryBuilder {
        private MerchantConfig merchantConfig;
        private InitConfig initConfig;
        private TransactionClient transactionClient;
        private ChecksumPayload checksumPayload;
        private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

        TransactionInitiatorFactoryBuilder() {
        }

        public TransactionInitiatorFactoryBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public TransactionInitiatorFactoryBuilder initConfig(InitConfig initConfig) {
            this.initConfig = initConfig;
            return this;
        }

        public TransactionInitiatorFactoryBuilder transactionClient(TransactionClient transactionClient) {
            this.transactionClient = transactionClient;
            return this;
        }

        public TransactionInitiatorFactoryBuilder checksumPayload(ChecksumPayload checksumPayload) {
            this.checksumPayload = checksumPayload;
            return this;
        }

        public TransactionInitiatorFactoryBuilder phonePeHttpRequestCreator(PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
            this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
            return this;
        }

        public TransactionInitiatorFactory build() {
            return new TransactionInitiatorFactory(this.merchantConfig, this.initConfig, this.transactionClient, this.checksumPayload, this.phonePeHttpRequestCreator);
        }

        public String toString() {
            return "TransactionInitiatorFactory.TransactionInitiatorFactoryBuilder(merchantConfig=" + this.merchantConfig + ", initConfig=" + this.initConfig + ", transactionClient=" + this.transactionClient + ", checksumPayload=" + this.checksumPayload + ", phonePeHttpRequestCreator=" + this.phonePeHttpRequestCreator + ")";
        }
    }
}

