/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.callback;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.transaction.status.models.TransactionStatusResponse;
import com.phonepe.sdk.javasdk.utils.Base64Utils;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(CallbackHandler.class);
    private TransactionStatusChecker transactionStatusChecker;
    private MerchantConfig merchantConfig;

    public CallbackHandler(TransactionStatusChecker transactionStatusChecker, MerchantConfig merchantConfig) {
        this.transactionStatusChecker = transactionStatusChecker;
        this.merchantConfig = merchantConfig;
    }

    public StatusResponse handleCallback(String responseReceived, String checksum, long transactionAmount) throws PhonePeClientException {
        Preconditions.checkNotNull((Object)responseReceived);
        Preconditions.checkNotNull((Object)checksum);
        try {
            String responseBody = Base64Utils.decodeBase64(responseReceived);
            PhonePeHttpResponse transactionStatusResponse = (PhonePeHttpResponse)new ObjectMapper().readValue(responseBody, (TypeReference)new TypeReference<PhonePeHttpResponse<TransactionStatusResponse>>(){});
            int keyIndex = KeyUtils.getKeyIndexFromChecksum(checksum);
            TransactionStatusResponse callbackResponseData = (TransactionStatusResponse)transactionStatusResponse.getData();
            String merchantId = callbackResponseData.getMerchantId();
            Long callbackAmount = callbackResponseData.getAmount();
            if (!this.isValidTransactionAmount(callbackAmount, transactionAmount)) {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Transaction amount passed does not match callback status response amount");
            }
            if (!this.isValidChecksum(responseReceived, checksum, keyIndex) || !this.isValidMerchantId(merchantId)) {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Invalid checksum or merchantId in callback response");
            }
            String transactionId = ((TransactionStatusResponse)transactionStatusResponse.getData()).getTransactionId();
            StatusResponse statusResponse = this.transactionStatusChecker.checkTransactionStatus(transactionId, keyIndex);
            if (!this.isValidTransactionAmount(callbackAmount, statusResponse.getAmount())) {
                throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Transaction amount mismatch in callback response and status check response");
            }
            return statusResponse;
        }
        catch (PhonePeClientException e) {
            log.error("Exception while handling callback: {}", (Object)e.getMessage());
            throw e;
        }
        catch (Exception ex) {
            log.error("Error in calling PhonePe init transaction API", (Throwable)ex);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("MESSAGE", ex.getMessage());
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.HTTP_CLIENT_ERROR, "Error executing http client: for initiating transaction: " + ex.getMessage(), objectMap, ex);
        }
    }

    private boolean isValidMerchantId(String merchantId) {
        return this.merchantConfig.getMerchantId().equals(merchantId);
    }

    private boolean isValidChecksum(String responseBody, String checksum, int keyIndex) throws Exception {
        String apiKey = KeyUtils.getAPIKeyFromIndex(this.merchantConfig.getApiKeys(), keyIndex);
        String generatedChecksum = ChecksumUtils.generateChecksumValue(responseBody, apiKey);
        return checksum.equalsIgnoreCase(generatedChecksum);
    }

    private boolean isValidTransactionAmount(Long callbackAmount, Long statusResponseAmount) {
        return callbackAmount.equals(statusResponseAmount);
    }

    public static CallbackHandlerBuilder builder() {
        return new CallbackHandlerBuilder();
    }

    public static class CallbackHandlerBuilder {
        private TransactionStatusChecker transactionStatusChecker;
        private MerchantConfig merchantConfig;

        CallbackHandlerBuilder() {
        }

        public CallbackHandlerBuilder transactionStatusChecker(TransactionStatusChecker transactionStatusChecker) {
            this.transactionStatusChecker = transactionStatusChecker;
            return this;
        }

        public CallbackHandlerBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public CallbackHandler build() {
            return new CallbackHandler(this.transactionStatusChecker, this.merchantConfig);
        }

        public String toString() {
            return "CallbackHandler.CallbackHandlerBuilder(transactionStatusChecker=" + this.transactionStatusChecker + ", merchantConfig=" + this.merchantConfig + ")";
        }
    }
}

