/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.SDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGeneratorFactory;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiatorFactory;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreatorFactory;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import java.util.List;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;

    public PhonePeClient(SDKConfig sdkConfig) {
        Preconditions.checkNotNull((Object)sdkConfig);
        this.init(sdkConfig);
    }

    public void init(SDKConfig sdkConfig) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpClientConfig httpClientConfig = sdkConfig.getHttpClientConfig();
        StatusConfig statusConfig = sdkConfig.getStatusConfig();
        MerchantConfig merchantConfig = sdkConfig.getMerchantConfig();
        InitConfig initConfig = sdkConfig.getInitConfig();
        HystrixConfig hystrixConfig = sdkConfig.getHystrixConfig();
        ChecksumGeneratorFactory checksumPayloadFactory = new ChecksumGeneratorFactory();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig);
        TransactionClient transactionClient = new TransactionClient(httpClientConfig, objectMapper, client, hystrixConfig);
        ChecksumGenerator statusChecksumGenerator = statusConfig.getApiVersion().accept(checksumPayloadFactory);
        ChecksumGenerator initChecksumGenerator = initConfig.getApiVersion().accept(checksumPayloadFactory);
        PhonePeHttpRequestCreatorFactory phonePeHttpRequestCreatorFactory = new PhonePeHttpRequestCreatorFactory();
        PhonePeHttpRequestCreator phonePeHttpRequestCreator = (PhonePeHttpRequestCreator)initConfig.getApiVersion().accept(phonePeHttpRequestCreatorFactory);
        TransactionInitiatorFactory transactionInitiatorFactory = TransactionInitiatorFactory.builder().merchantConfig(merchantConfig).initConfig(initConfig).transactionClient(transactionClient).checksumGenerator(initChecksumGenerator).phonePeHttpRequestCreator(phonePeHttpRequestCreator).build();
        this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).checksumGenerator(statusChecksumGenerator).build();
        this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
        this.transactionInitiator = initConfig.getInitType().accept(transactionInitiatorFactory);
    }

    public InitResponse initTransaction(String transactionId, Long amount) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, offerTags);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, offerTags, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, "", amount, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, userId, amount, null, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, String userId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, amount, "", userId, "", "", "", "", "", "", offerTags, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) throws PhonePeClientException {
        return this.initTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints, "", "", "", "");
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callbackURL, String callMode) throws PhonePeClientException {
        return this.initTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, 1);
    }

    public InitResponse initTransaction(String transactionId, Long amount, String orderId, String userId, String subMerchant, String subMerchantId, String mobileNumber, String emailId, String shortName, String message, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callMode, String callbackURL, int keyIndex) throws PhonePeClientException {
        return this.transactionInitiator.initiateTransaction(transactionId, amount, orderId, userId, subMerchant, subMerchantId, mobileNumber, emailId, shortName, message, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, keyIndex);
    }

    public StatusResponse handleCallback(String responseReceived, String checksum, long transactionAmount) throws PhonePeClientException {
        return this.callbackHandler.handleCallback(responseReceived, checksum, transactionAmount);
    }

    public StatusResponse checkTransactionStatus(String transactionId) throws PhonePeClientException {
        return this.checkTransactionStatus(transactionId, 1);
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) throws PhonePeClientException {
        return this.statusChecker.checkTransactionStatus(transactionId, keyIndex);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public TransactionInitiator getTransactionInitiator() {
        return this.transactionInitiator;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public TransactionStatusChecker getStatusChecker() {
        return this.statusChecker;
    }

    public void setTransactionInitiator(TransactionInitiator transactionInitiator) {
        this.transactionInitiator = transactionInitiator;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setStatusChecker(TransactionStatusChecker statusChecker) {
        this.statusChecker = statusChecker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PhonePeClient)) {
            return false;
        }
        PhonePeClient other = (PhonePeClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionInitiator this$transactionInitiator = this.getTransactionInitiator();
        TransactionInitiator other$transactionInitiator = other.getTransactionInitiator();
        if (this$transactionInitiator == null ? other$transactionInitiator != null : !((Object)this$transactionInitiator).equals(other$transactionInitiator)) {
            return false;
        }
        CallbackHandler this$callbackHandler = this.getCallbackHandler();
        CallbackHandler other$callbackHandler = other.getCallbackHandler();
        if (this$callbackHandler == null ? other$callbackHandler != null : !this$callbackHandler.equals(other$callbackHandler)) {
            return false;
        }
        TransactionStatusChecker this$statusChecker = this.getStatusChecker();
        TransactionStatusChecker other$statusChecker = other.getStatusChecker();
        return !(this$statusChecker == null ? other$statusChecker != null : !this$statusChecker.equals(other$statusChecker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PhonePeClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionInitiator $transactionInitiator = this.getTransactionInitiator();
        result = result * 59 + ($transactionInitiator == null ? 43 : ((Object)$transactionInitiator).hashCode());
        CallbackHandler $callbackHandler = this.getCallbackHandler();
        result = result * 59 + ($callbackHandler == null ? 43 : $callbackHandler.hashCode());
        TransactionStatusChecker $statusChecker = this.getStatusChecker();
        result = result * 59 + ($statusChecker == null ? 43 : $statusChecker.hashCode());
        return result;
    }

    public String toString() {
        return "PhonePeClient(transactionInitiator=" + this.getTransactionInitiator() + ", callbackHandler=" + this.getCallbackHandler() + ", statusChecker=" + this.getStatusChecker() + ")";
    }

    public static class PhonePeClientBuilder {
        private SDKConfig sdkConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder sdkConfig(SDKConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public PhonePeClient build() {
            return new PhonePeClient(this.sdkConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(sdkConfig=" + this.sdkConfig + ")";
        }
    }
}

