package com.phonepe.sdk.javasdk.transaction.checksum;

import com.phonepe.sdk.javasdk.config.models.enums.APIVersion.APIVersionVisitor;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.BodyChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ParamsChecksumGenerator;

public class ChecksumGeneratorFactory implements APIVersionVisitor<ChecksumGenerator> {

    @Override
    public ChecksumGenerator visitV1() {
        return ParamsChecksumGenerator
                .builder().build();
    }

    @Override
    public ChecksumGenerator visitV2() {
        return ParamsChecksumGenerator
                .builder().build();
    }

    @Override
    public ChecksumGenerator visitV3() {
        return BodyChecksumGenerator
                .builder().build();
    }

    @Override
    public ChecksumGenerator visitV4() {
        return BodyChecksumGenerator
                .builder().build();
    }
}
