package com.phonepe.sdk.javasdk.transaction.init.web;

import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.AccountConstraintsDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.BaseTransactionInit;
import com.phonepe.sdk.javasdk.transaction.init.decorator.OfferInitDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.Set;

@Slf4j
public class WebTransactionInitiator extends TransactionInitiator {


    @Builder
    public WebTransactionInitiator(final TransactionClient transactionClient,
                                   final InitConfig initConfig,
                                   final MerchantConfig merchantConfig,
                                   final ChecksumGenerator checksumGenerator,
                                   final PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        super(transactionClient, initConfig, merchantConfig,
              checksumGenerator, phonePeHttpRequestCreator);
    }

    @Override
    protected PhonePeHttpRequest<?> buildInitRequest(final String merchantId,
                                                     final String transactionId,
                                                     final Long amount,
                                                     final String merchantOrderId,
                                                     final String merchantUserId,
                                                     final String subMerchant,
                                                     final String subMerchantId,
                                                     final String mobileNumber,
                                                     final String emailId,
                                                     final String shortName,
                                                     final String message,
                                                     final Set<String> offerTags,
                                                     final List<AllowedAccountConstraint> allowedAccountConstraints) throws Exception {

        TransactionInitComponent transactionInitComponent = BaseTransactionInit.builder()
                                                                               .merchantId(merchantId)
                                                                               .transactionId(transactionId)
                                                                               .amount(amount)
                                                                               .emailId(emailId)
                                                                               .merchantOrderId(merchantOrderId)
                                                                               .merchantUserId(merchantUserId)
                                                                               .mobileNumber(mobileNumber)
                                                                               .shortName(shortName)
                                                                               .subMerchant(subMerchant)
                                                                               .subMerchantId(subMerchantId)
                                                                               .message(message)
                                                                               .build();
        if (CollectionUtils.isNotEmpty(offerTags)) {
            transactionInitComponent = OfferInitDecorator
                    .builder()
                    .transactionInitComponent(transactionInitComponent)
                    .offerTagIds(offerTags)
                    .build();
        }
        if (CollectionUtils.isNotEmpty(allowedAccountConstraints)) {
            transactionInitComponent = AccountConstraintsDecorator
                    .builder()
                    .transactionInitComponent(transactionInitComponent)
                    .allowedAccountConstraints(allowedAccountConstraints)
                    .build();
        }
        final InitRequest initRequest = transactionInitComponent.getInitRequest();
        return this.phonePeHttpRequestCreator.createPhonePeHttpRequest(initRequest);
    }
}
