package com.phonepe.sdk.javasdk.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;


@Slf4j
public class ChecksumUtils {

    private static final String SEPARATOR_VaLUE = "###";

    public static String generateChecksumHeader(final String checksumValue, final int apiKeyIndex){
        return checksumValue.concat(SEPARATOR_VaLUE).concat(Integer.toString(apiKeyIndex));
    }

    public static String generateChecksumValue(final String checksumPayload, final String apiKey){
        String hex = checksumPayload.concat(apiKey);
        return DigestUtils.sha256Hex(hex);
    }
}
