package com.phonepe.sdk.javasdk.utils;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.google.common.base.Predicate;
import com.phonepe.sdk.javasdk.config.models.RetryConfig;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class RetryUtils<T> {

    public static <T> Retryer<T> getRetryer(RetryConfig retryConfig, Predicate<T> predicate) {
        return RetryerBuilder.<T>newBuilder()
                .retryIfException()
                .retryIfResult(predicate)
                .withStopStrategy(StopStrategies.stopAfterAttempt(retryConfig.getMaxRetry()))
                .withWaitStrategy(retryConfig.getWaitStrategy())
                .build();
    }
}
