package com.phonepe.sdk.javasdk.exception;

import java.util.Map;

public class PhonePeClientException extends Exception {
    private Map<String,Object> details;
    public ErrorCode getErrorCode() {
        return errorCode;
    }

    public enum ErrorCode {
        VALIDATION_ERROR,
        HTTP_CLIENT_ERROR,
        HTTP_SERVER_ERROR,
        EXECUTION_ERROR
    }

    private final ErrorCode errorCode;

    public PhonePeClientException(ErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public PhonePeClientException(ErrorCode errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public PhonePeClientException(ErrorCode errorCode, String message, Map<String, Object> details) {
        super(message);
        this.errorCode = errorCode;
        this.details=details;
    }

    public PhonePeClientException(ErrorCode errorCode, String message, Map<String, Object> details, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.details=details;
    }

    public Map<String, Object> getDetails() {
        return details;
    }

}
