package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class HttpClientConfig {

    @NotNull
    @Valid
    private Endpoint endpoint;

    @Min(10)
    @Max(1024)
    private int connections = 10;

    @Max(86400)
    private int idleTimeOutSeconds = 30;

    @Max(86400000)
    private int connectTimeoutMs = 10000;

    @Max(86400000)
    private int opTimeoutMs = 10000;

}

