/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.Endpoint;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HttpClientConfig {
    @NotNull
    @Valid
    private Endpoint endpoint;
    @Min(value=10L)
    @Max(value=1024L)
    private int connections = 10;
    @Max(value=86400L)
    private int idleTimeOutSeconds = 30;
    @Max(value=86400000L)
    private int connectTimeoutMs = 10000;
    @Max(value=86400000L)
    private int opTimeoutMs = 10000;

    public static HttpClientConfigBuilder builder() {
        return new HttpClientConfigBuilder();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public int getConnections() {
        return this.connections;
    }

    public int getIdleTimeOutSeconds() {
        return this.idleTimeOutSeconds;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getOpTimeoutMs() {
        return this.opTimeoutMs;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public void setIdleTimeOutSeconds(int idleTimeOutSeconds) {
        this.idleTimeOutSeconds = idleTimeOutSeconds;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setOpTimeoutMs(int opTimeoutMs) {
        this.opTimeoutMs = opTimeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfig)) {
            return false;
        }
        HttpClientConfig other = (HttpClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Endpoint this$endpoint = this.getEndpoint();
        Endpoint other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !((Object)this$endpoint).equals(other$endpoint)) {
            return false;
        }
        if (this.getConnections() != other.getConnections()) {
            return false;
        }
        if (this.getIdleTimeOutSeconds() != other.getIdleTimeOutSeconds()) {
            return false;
        }
        if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
            return false;
        }
        return this.getOpTimeoutMs() == other.getOpTimeoutMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Endpoint $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : ((Object)$endpoint).hashCode());
        result = result * 59 + this.getConnections();
        result = result * 59 + this.getIdleTimeOutSeconds();
        result = result * 59 + this.getConnectTimeoutMs();
        result = result * 59 + this.getOpTimeoutMs();
        return result;
    }

    public String toString() {
        return "HttpClientConfig(endpoint=" + this.getEndpoint() + ", connections=" + this.getConnections() + ", idleTimeOutSeconds=" + this.getIdleTimeOutSeconds() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", opTimeoutMs=" + this.getOpTimeoutMs() + ")";
    }

    public HttpClientConfig(Endpoint endpoint, int connections, int idleTimeOutSeconds, int connectTimeoutMs, int opTimeoutMs) {
        this.endpoint = endpoint;
        this.connections = connections;
        this.idleTimeOutSeconds = idleTimeOutSeconds;
        this.connectTimeoutMs = connectTimeoutMs;
        this.opTimeoutMs = opTimeoutMs;
    }

    public HttpClientConfig() {
    }

    public static class HttpClientConfigBuilder {
        private Endpoint endpoint;
        private int connections;
        private int idleTimeOutSeconds;
        private int connectTimeoutMs;
        private int opTimeoutMs;

        HttpClientConfigBuilder() {
        }

        public HttpClientConfigBuilder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public HttpClientConfigBuilder connections(int connections) {
            this.connections = connections;
            return this;
        }

        public HttpClientConfigBuilder idleTimeOutSeconds(int idleTimeOutSeconds) {
            this.idleTimeOutSeconds = idleTimeOutSeconds;
            return this;
        }

        public HttpClientConfigBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public HttpClientConfigBuilder opTimeoutMs(int opTimeoutMs) {
            this.opTimeoutMs = opTimeoutMs;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.endpoint, this.connections, this.idleTimeOutSeconds, this.connectTimeoutMs, this.opTimeoutMs);
        }

        public String toString() {
            return "HttpClientConfig.HttpClientConfigBuilder(endpoint=" + this.endpoint + ", connections=" + this.connections + ", idleTimeOutSeconds=" + this.idleTimeOutSeconds + ", connectTimeoutMs=" + this.connectTimeoutMs + ", opTimeoutMs=" + this.opTimeoutMs + ")";
        }
    }
}

