/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.HandlerAdapter;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.Future;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHttpCommand<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseHttpCommand.class);
    OkHttpClient client;
    String command;
    Endpoint endpoint;
    String url = null;
    List<HttpHeaderPair> headers = null;
    PhonePeHttpRequest httpRequest;
    ObjectMapper mapper;
    Class<T> responseType;
    TypeReference<T> responseTypeReference;
    Consumer<Exception, T> exceptionConsumer;
    Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;
    HystrixConfig hystrixConfig;

    BaseHttpCommand(OkHttpClient client, HystrixConfig hystrixConfig, String command, Endpoint endpoint, String url, List<HttpHeaderPair> headers, PhonePeHttpRequest httpRequest, ObjectMapper mapper, Class<T> responseType, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        this.client = client;
        this.hystrixConfig = hystrixConfig;
        this.command = command;
        this.endpoint = endpoint;
        this.url = url;
        this.headers = headers;
        this.httpRequest = httpRequest;
        this.mapper = mapper;
        this.responseType = responseType;
        this.exceptionConsumer = exceptionConsumer;
        this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
        this.responseTypeReference = responseTypeReference;
    }

    RequestBody getRequestBody() throws JsonProcessingException {
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsBytes(this.httpRequest.getData()));
    }

    public abstract Request getRequest(HttpUrl var1) throws JsonProcessingException;

    public T execute() throws Exception {
        this.preconditions();
        Request request = null;
        try {
            HttpUrl httpUrl = this.endpoint.isSecured() ? HttpUtils.getSecureHttpUrl(this.endpoint, this.url) : HttpUtils.getHttpUrl(this.endpoint, this.url);
            request = this.getRequest(httpUrl);
            log.info("Service {} request: {}", (Object)this.command, (Object)request);
            Response response = this.client.newCall(request).execute();
            byte[] responseBody = HttpUtils.body(response);
            if (!response.isSuccessful()) {
                if (this.nonSuccessResponseConsumer != null) {
                    return this.nonSuccessResponseConsumer.consume(this.extract(response, responseBody));
                }
                log.error(String.format("Service %s call failed statusCode:%d request:%s response:%s", this.command, response.code(), request, new String(responseBody)));
                throw new Exception("Service " + this.command + " call failure: " + response.code());
            }
            if (this.responseTypeReference != null) {
                return (T)this.mapper.readValue(responseBody, this.responseTypeReference);
            }
            if (byte[].class.equals(this.responseType)) {
                return (T)responseBody;
            }
            if (String.class.equals(this.responseType)) {
                return (T)new String(responseBody, Charset.defaultCharset());
            }
            return (T)this.mapper.readValue(responseBody, this.responseType);
        }
        catch (Exception e) {
            if (this.exceptionConsumer != null) {
                return this.exceptionConsumer.consume(e);
            }
            log.error(String.format("Error executing %s request:%s error:%s", this.command, request, e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void preconditions() {
        Preconditions.checkNotNull((Object)this.client, (Object)"client cant be null");
        Preconditions.checkNotNull((Object)this.endpoint, (Object)"endpoint cant be null");
        Preconditions.checkNotNull((Object)this.url, (Object)"url cant be null");
        Preconditions.checkNotNull((Object)this.mapper, (Object)"object mapper cant be null");
        HttpUtils.checkNotNull(this.responseType, this.responseTypeReference, "both responseType and responseTypeReference cant be null");
    }

    private ExtractedResponse extract(Response response, byte[] responseBody) {
        return ExtractedResponse.builder().body(responseBody).code(response.code()).headers(response.headers()).message(response.message()).protocol(response.protocol()).handshake(response.handshake()).receivedResponseAtMillis(response.receivedResponseAtMillis()).sentRequestAtMillis(response.sentRequestAtMillis()).build();
    }

    public T executeTracked(Class clazz) throws Exception {
        try {
            return (T)this.hystrixExecutor(new HandlerAdapter<T>(){

                @Override
                public T run() throws Exception {
                    return BaseHttpCommand.this.execute();
                }
            }, this.commandKey(clazz.getSimpleName(), this.getCommand())).execute();
        }
        catch (Exception e) {
            Consumer<Exception, Exception> exceptionConsumer = this.getExceptionConsumer();
            if (exceptionConsumer != null) {
                return exceptionConsumer.consume(e);
            }
            throw e;
        }
    }

    public Future<T> queueTracked(Class clazz) throws Exception {
        return this.hystrixExecutor(new HandlerAdapter<T>(){

            @Override
            public T run() throws Exception {
                return BaseHttpCommand.this.execute();
            }
        }, this.commandKey(clazz.getSimpleName(), this.getCommand())).queue();
    }

    public HystrixCommand<T> hystrixExecutor(final HandlerAdapter<T> function, String key) throws Exception {
        return new HystrixCommand<T>(this.getSetter(this.hystrixConfig, key)){

            protected T run() throws Exception {
                Object var1 = function.run();
                return var1;
            }
        };
    }

    private String commandKey(String group, String command) {
        return String.format("%s.%s", group, command);
    }

    private HystrixCommand.Setter getSetter(HystrixConfig hystrixConfig, String key) {
        return HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)key)).andCommandKey(HystrixCommandKey.Factory.asKey((String)key)).andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey((String)key)).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.THREAD).withExecutionIsolationSemaphoreMaxConcurrentRequests(hystrixConfig.getThreadPool().getConcurrency()).withFallbackIsolationSemaphoreMaxConcurrentRequests(hystrixConfig.getThreadPool().getConcurrency()).withFallbackEnabled(false).withCircuitBreakerErrorThresholdPercentage(hystrixConfig.getCircuitBreaker().getErrorThreshold()).withCircuitBreakerRequestVolumeThreshold(hystrixConfig.getCircuitBreaker().getAcceptableFailuresInWindow()).withCircuitBreakerSleepWindowInMilliseconds(hystrixConfig.getCircuitBreaker().getWaitTimeBeforeRetry()).withExecutionTimeoutInMilliseconds(hystrixConfig.getThreadPool().getTimeout()).withMetricsHealthSnapshotIntervalInMilliseconds(hystrixConfig.getMetrics().getHealthCheckInterval()).withMetricsRollingPercentileBucketSize(hystrixConfig.getMetrics().getPercentileBucketSize()).withMetricsRollingPercentileWindowInMilliseconds(hystrixConfig.getMetrics().getPercentileTimeInMillis())).andThreadPoolPropertiesDefaults(HystrixThreadPoolProperties.Setter().withCoreSize(hystrixConfig.getThreadPool().getConcurrency()).withMaxQueueSize(hystrixConfig.getThreadPool().getMaxRequestQueueSize()).withQueueSizeRejectionThreshold(hystrixConfig.getThreadPool().getDynamicRequestQueueSize()).withMetricsRollingStatisticalWindowBuckets(hystrixConfig.getMetrics().getNumBucketSize()).withMetricsRollingStatisticalWindowInMilliseconds(hystrixConfig.getMetrics().getStatsTimeInMillis()));
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public String getUrl() {
        return this.url;
    }

    public List<HttpHeaderPair> getHeaders() {
        return this.headers;
    }

    public PhonePeHttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public Class<T> getResponseType() {
        return this.responseType;
    }

    public TypeReference<T> getResponseTypeReference() {
        return this.responseTypeReference;
    }

    public Consumer<Exception, T> getExceptionConsumer() {
        return this.exceptionConsumer;
    }

    public Consumer<ExtractedResponse, T> getNonSuccessResponseConsumer() {
        return this.nonSuccessResponseConsumer;
    }

    public HystrixConfig getHystrixConfig() {
        return this.hystrixConfig;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHeaders(List<HttpHeaderPair> headers) {
        this.headers = headers;
    }

    public void setHttpRequest(PhonePeHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setResponseType(Class<T> responseType) {
        this.responseType = responseType;
    }

    public void setResponseTypeReference(TypeReference<T> responseTypeReference) {
        this.responseTypeReference = responseTypeReference;
    }

    public void setExceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
        this.exceptionConsumer = exceptionConsumer;
    }

    public void setNonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
        this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
    }

    public void setHystrixConfig(HystrixConfig hystrixConfig) {
        this.hystrixConfig = hystrixConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseHttpCommand)) {
            return false;
        }
        BaseHttpCommand other = (BaseHttpCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OkHttpClient this$client = this.getClient();
        OkHttpClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Endpoint this$endpoint = this.getEndpoint();
        Endpoint other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !((Object)this$endpoint).equals(other$endpoint)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<HttpHeaderPair> this$headers = this.getHeaders();
        List<HttpHeaderPair> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        PhonePeHttpRequest this$httpRequest = this.getHttpRequest();
        PhonePeHttpRequest other$httpRequest = other.getHttpRequest();
        if (this$httpRequest == null ? other$httpRequest != null : !((Object)this$httpRequest).equals(other$httpRequest)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        Class<T> this$responseType = this.getResponseType();
        Class<T> other$responseType = other.getResponseType();
        if (this$responseType == null ? other$responseType != null : !this$responseType.equals(other$responseType)) {
            return false;
        }
        TypeReference<T> this$responseTypeReference = this.getResponseTypeReference();
        TypeReference<T> other$responseTypeReference = other.getResponseTypeReference();
        if (this$responseTypeReference == null ? other$responseTypeReference != null : !this$responseTypeReference.equals(other$responseTypeReference)) {
            return false;
        }
        Consumer<Exception, T> this$exceptionConsumer = this.getExceptionConsumer();
        Consumer<Exception, T> other$exceptionConsumer = other.getExceptionConsumer();
        if (this$exceptionConsumer == null ? other$exceptionConsumer != null : !this$exceptionConsumer.equals(other$exceptionConsumer)) {
            return false;
        }
        Consumer<ExtractedResponse, T> this$nonSuccessResponseConsumer = this.getNonSuccessResponseConsumer();
        Consumer<ExtractedResponse, T> other$nonSuccessResponseConsumer = other.getNonSuccessResponseConsumer();
        if (this$nonSuccessResponseConsumer == null ? other$nonSuccessResponseConsumer != null : !this$nonSuccessResponseConsumer.equals(other$nonSuccessResponseConsumer)) {
            return false;
        }
        HystrixConfig this$hystrixConfig = this.getHystrixConfig();
        HystrixConfig other$hystrixConfig = other.getHystrixConfig();
        return !(this$hystrixConfig == null ? other$hystrixConfig != null : !((Object)this$hystrixConfig).equals(other$hystrixConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseHttpCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OkHttpClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Endpoint $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : ((Object)$endpoint).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<HttpHeaderPair> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        PhonePeHttpRequest $httpRequest = this.getHttpRequest();
        result = result * 59 + ($httpRequest == null ? 43 : ((Object)$httpRequest).hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        Class<T> $responseType = this.getResponseType();
        result = result * 59 + ($responseType == null ? 43 : $responseType.hashCode());
        TypeReference<T> $responseTypeReference = this.getResponseTypeReference();
        result = result * 59 + ($responseTypeReference == null ? 43 : $responseTypeReference.hashCode());
        Consumer<Exception, T> $exceptionConsumer = this.getExceptionConsumer();
        result = result * 59 + ($exceptionConsumer == null ? 43 : $exceptionConsumer.hashCode());
        Consumer<ExtractedResponse, T> $nonSuccessResponseConsumer = this.getNonSuccessResponseConsumer();
        result = result * 59 + ($nonSuccessResponseConsumer == null ? 43 : $nonSuccessResponseConsumer.hashCode());
        HystrixConfig $hystrixConfig = this.getHystrixConfig();
        result = result * 59 + ($hystrixConfig == null ? 43 : ((Object)$hystrixConfig).hashCode());
        return result;
    }

    public String toString() {
        return "BaseHttpCommand(client=" + this.getClient() + ", command=" + this.getCommand() + ", endpoint=" + this.getEndpoint() + ", url=" + this.getUrl() + ", headers=" + this.getHeaders() + ", httpRequest=" + this.getHttpRequest() + ", mapper=" + this.getMapper() + ", responseType=" + this.getResponseType() + ", responseTypeReference=" + this.getResponseTypeReference() + ", exceptionConsumer=" + this.getExceptionConsumer() + ", nonSuccessResponseConsumer=" + this.getNonSuccessResponseConsumer() + ", hystrixConfig=" + this.getHystrixConfig() + ")";
    }
}

