package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class HystrixConfig {

    private ThreadPool threadPool = new ThreadPool();

    private Metrics metrics = new Metrics();

    private CircuitBreaker circuitBreaker = new CircuitBreaker();

    @Builder
    @SuppressWarnings("unused")
    public HystrixConfig(ThreadPool threadPool, Metrics metrics, CircuitBreaker circuitBreaker){
        this.threadPool = threadPool == null ? new ThreadPool() : threadPool;
        this.metrics = metrics == null ? new Metrics() : metrics;
        this.circuitBreaker = circuitBreaker == null ? new CircuitBreaker(): circuitBreaker;
    }
}
