package com.phonepe.sdk.javasdk.utils;

import com.phonepe.sdk.javasdk.config.models.APIKeyConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class KeyUtils {

    private KeyUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int getKeyIndexFromChecksum(final String checksumString){
        return Integer.parseInt(checksumString.substring(checksumString.lastIndexOf('#')+1));
    }

    public static String getAPIKeyFromIndex(List<APIKeyConfig> apiKeys, int keyIndex) throws PhonePeClientException {
        for(APIKeyConfig apiKey : apiKeys){
            if(apiKey.getKeyIndex() == keyIndex)
                return apiKey.getKeyValue();
        }
        throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR,"Key not found with given index " + keyIndex + "for the merchant in the config");
    }
}
