/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class SDKConfig {
    @Valid
    @NotNull
    private MerchantConfig merchantConfig;
    @Valid
    @NotNull
    private HttpClientConfig httpClientConfig;
    @Valid
    private InitConfig initConfig = InitConfig.builder().build();
    @Valid
    private StatusConfig statusConfig = StatusConfig.builder().build();
    @Valid
    private HystrixConfig hystrixConfig = HystrixConfig.builder().build();

    public SDKConfig(MerchantConfig merchantConfig, HttpClientConfig httpClientConfig, InitConfig initConfig, StatusConfig statusConfig, HystrixConfig hystrixConfig) {
        this.merchantConfig = merchantConfig;
        this.httpClientConfig = httpClientConfig;
        this.initConfig = initConfig == null ? InitConfig.builder().build() : initConfig;
        this.statusConfig = statusConfig == null ? StatusConfig.builder().build() : statusConfig;
        this.hystrixConfig = hystrixConfig == null ? HystrixConfig.builder().build() : hystrixConfig;
    }

    public static SDKConfigBuilder builder() {
        return new SDKConfigBuilder();
    }

    public MerchantConfig getMerchantConfig() {
        return this.merchantConfig;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public InitConfig getInitConfig() {
        return this.initConfig;
    }

    public StatusConfig getStatusConfig() {
        return this.statusConfig;
    }

    public HystrixConfig getHystrixConfig() {
        return this.hystrixConfig;
    }

    public void setMerchantConfig(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    public void setInitConfig(InitConfig initConfig) {
        this.initConfig = initConfig;
    }

    public void setStatusConfig(StatusConfig statusConfig) {
        this.statusConfig = statusConfig;
    }

    public void setHystrixConfig(HystrixConfig hystrixConfig) {
        this.hystrixConfig = hystrixConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SDKConfig)) {
            return false;
        }
        SDKConfig other = (SDKConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MerchantConfig this$merchantConfig = this.getMerchantConfig();
        MerchantConfig other$merchantConfig = other.getMerchantConfig();
        if (this$merchantConfig == null ? other$merchantConfig != null : !((Object)this$merchantConfig).equals(other$merchantConfig)) {
            return false;
        }
        HttpClientConfig this$httpClientConfig = this.getHttpClientConfig();
        HttpClientConfig other$httpClientConfig = other.getHttpClientConfig();
        if (this$httpClientConfig == null ? other$httpClientConfig != null : !((Object)this$httpClientConfig).equals(other$httpClientConfig)) {
            return false;
        }
        InitConfig this$initConfig = this.getInitConfig();
        InitConfig other$initConfig = other.getInitConfig();
        if (this$initConfig == null ? other$initConfig != null : !((Object)this$initConfig).equals(other$initConfig)) {
            return false;
        }
        StatusConfig this$statusConfig = this.getStatusConfig();
        StatusConfig other$statusConfig = other.getStatusConfig();
        if (this$statusConfig == null ? other$statusConfig != null : !((Object)this$statusConfig).equals(other$statusConfig)) {
            return false;
        }
        HystrixConfig this$hystrixConfig = this.getHystrixConfig();
        HystrixConfig other$hystrixConfig = other.getHystrixConfig();
        return !(this$hystrixConfig == null ? other$hystrixConfig != null : !((Object)this$hystrixConfig).equals(other$hystrixConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SDKConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MerchantConfig $merchantConfig = this.getMerchantConfig();
        result = result * 59 + ($merchantConfig == null ? 43 : ((Object)$merchantConfig).hashCode());
        HttpClientConfig $httpClientConfig = this.getHttpClientConfig();
        result = result * 59 + ($httpClientConfig == null ? 43 : ((Object)$httpClientConfig).hashCode());
        InitConfig $initConfig = this.getInitConfig();
        result = result * 59 + ($initConfig == null ? 43 : ((Object)$initConfig).hashCode());
        StatusConfig $statusConfig = this.getStatusConfig();
        result = result * 59 + ($statusConfig == null ? 43 : ((Object)$statusConfig).hashCode());
        HystrixConfig $hystrixConfig = this.getHystrixConfig();
        result = result * 59 + ($hystrixConfig == null ? 43 : ((Object)$hystrixConfig).hashCode());
        return result;
    }

    public String toString() {
        return "SDKConfig(merchantConfig=" + this.getMerchantConfig() + ", httpClientConfig=" + this.getHttpClientConfig() + ", initConfig=" + this.getInitConfig() + ", statusConfig=" + this.getStatusConfig() + ", hystrixConfig=" + this.getHystrixConfig() + ")";
    }

    public SDKConfig() {
    }

    public static class SDKConfigBuilder {
        private MerchantConfig merchantConfig;
        private HttpClientConfig httpClientConfig;
        private InitConfig initConfig;
        private StatusConfig statusConfig;
        private HystrixConfig hystrixConfig;

        SDKConfigBuilder() {
        }

        public SDKConfigBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public SDKConfigBuilder httpClientConfig(HttpClientConfig httpClientConfig) {
            this.httpClientConfig = httpClientConfig;
            return this;
        }

        public SDKConfigBuilder initConfig(InitConfig initConfig) {
            this.initConfig = initConfig;
            return this;
        }

        public SDKConfigBuilder statusConfig(StatusConfig statusConfig) {
            this.statusConfig = statusConfig;
            return this;
        }

        public SDKConfigBuilder hystrixConfig(HystrixConfig hystrixConfig) {
            this.hystrixConfig = hystrixConfig;
            return this;
        }

        public SDKConfig build() {
            return new SDKConfig(this.merchantConfig, this.httpClientConfig, this.initConfig, this.statusConfig, this.hystrixConfig);
        }

        public String toString() {
            return "SDKConfig.SDKConfigBuilder(merchantConfig=" + this.merchantConfig + ", httpClientConfig=" + this.httpClientConfig + ", initConfig=" + this.initConfig + ", statusConfig=" + this.statusConfig + ", hystrixConfig=" + this.hystrixConfig + ")";
        }
    }
}

