package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class CircuitBreaker {

    private int acceptableFailuresInWindow = 20;
    private int waitTimeBeforeRetry = 5000;
    private int errorThreshold = 50;

    @Builder
    public CircuitBreaker(final int acceptableFailuresInWindow, final int waitTimeBeforeRetry,
                          final int errorThreshold) {
        this.acceptableFailuresInWindow = acceptableFailuresInWindow == 0 ? 20 : acceptableFailuresInWindow;
        this.waitTimeBeforeRetry = waitTimeBeforeRetry == 0 ? 5000 : waitTimeBeforeRetry;
        this.errorThreshold = errorThreshold == 0 ? 50 : errorThreshold;
    }
}
