package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;

@Data
@NoArgsConstructor
public class Metrics {

    @Max(60000L)
    private int statsTimeInMillis = 60000;
    private int healthCheckInterval = 500;
    private int percentileTimeInMillis = 60000;
    private int percentileBucketSize = 100;
    private int numBucketSize = 100;

    @Builder
    public Metrics(@Max(60000L) final int statsTimeInMillis, final int healthCheckInterval,
                   final int percentileTimeInMillis, final int percentileBucketSize,
                   final int numBucketSize) {
        this.statsTimeInMillis = statsTimeInMillis == 0 ? 60000 : statsTimeInMillis;
        this.healthCheckInterval = healthCheckInterval == 0 ? 500 : healthCheckInterval;
        this.percentileTimeInMillis = percentileTimeInMillis == 0 ? 60000 : percentileTimeInMillis;
        this.percentileBucketSize = percentileBucketSize == 0 ? 100 : percentileBucketSize;
        this.numBucketSize = numBucketSize == 0 ? 100 : numBucketSize;
    }
}
