/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.enums.Environment;
import java.net.URI;
import javax.validation.constraints.NotNull;
import okhttp3.HttpUrl;

public class Endpoint {
    @NotNull
    private Environment environment;

    public HttpUrl getUrl(String path) {
        String protocol = this.environment.isSecured() ? "https" : "http";
        return HttpUrl.get((URI)URI.create(String.format("%s://%s%s", protocol, this.environment.getHost(), path)));
    }

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        return !(this$environment == null ? other$environment != null : !((Object)((Object)this$environment)).equals((Object)other$environment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)((Object)$environment)).hashCode());
        return result;
    }

    public String toString() {
        return "Endpoint(environment=" + (Object)((Object)this.getEnvironment()) + ")";
    }

    public Endpoint(Environment environment) {
        this.environment = environment;
    }

    public Endpoint() {
    }

    public static class EndpointBuilder {
        private Environment environment;

        EndpointBuilder() {
        }

        public EndpointBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.environment);
        }

        public String toString() {
            return "Endpoint.EndpointBuilder(environment=" + (Object)((Object)this.environment) + ")";
        }
    }
}

