/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http.utils;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    public static final String APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHECKSUM_HEADER = "X-VERIFY";
    public static final String LOCATION_HEADER = "location";
    public static final String PROVIDER_ID_HEADER = "X-PROVIDER-ID";
    public static final String REDIRECT_URL_HEADER = "X-REDIRECT-URL";
    public static final String REDIRECT_MODE_HEADER = "X-REDIRECT-MODE";
    public static final String CALLBACK_URL_HEADER = "X-CALLBACK-URL";
    public static final String CALL_MODE_HEADER = "X-CALL-MODE";

    private HttpUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] body(Response response) throws IOException {
        ResponseBody body = response.body();
        return body.bytes();
    }

    public static HttpHeaderPair getHeaderPair(String name, String value) {
        return HttpHeaderPair.builder().name(name).value(value).build();
    }

    public static HttpHeaderPair getContentTypeHeaderPair() {
        return HttpUtils.getHeaderPair(CONTENT_TYPE, APPLICATION_JSON);
    }

    public static <T1, T2> void checkNotNull(T1 t, T2 t2, String message) throws PhonePeClientException {
        if (t == null && t2 == null) {
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, message);
        }
    }

    public static List<HttpHeaderPair> getHttpHeaders(String checksum, String providerId, String redirectURL, String redirectMode, String callbackURL, String callMode) {
        Preconditions.checkNotNull((Object)checksum);
        List<HttpHeaderPair> headerPairs = HttpUtils.getHttpHeaders(checksum);
        if (StringUtils.isNotEmpty((CharSequence)providerId)) {
            HttpHeaderPair providerIdHeader = HttpUtils.getHeaderPair(PROVIDER_ID_HEADER, providerId);
            headerPairs.add(providerIdHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectURL)) {
            HttpHeaderPair redirectURLHeader = HttpUtils.getHeaderPair(REDIRECT_URL_HEADER, redirectURL);
            headerPairs.add(redirectURLHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)redirectMode)) {
            HttpHeaderPair redirectModeHeader = HttpUtils.getHeaderPair(REDIRECT_MODE_HEADER, redirectMode);
            headerPairs.add(redirectModeHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)callbackURL)) {
            HttpHeaderPair callbackURLHeader = HttpUtils.getHeaderPair(CALLBACK_URL_HEADER, callbackURL);
            headerPairs.add(callbackURLHeader);
        }
        if (StringUtils.isNotEmpty((CharSequence)callMode)) {
            HttpHeaderPair callbackModeHeader = HttpUtils.getHeaderPair(CALL_MODE_HEADER, callMode);
            headerPairs.add(callbackModeHeader);
        }
        return headerPairs;
    }

    public static List<HttpHeaderPair> getHttpHeaders(String checksum) {
        ArrayList<HttpHeaderPair> headerPairs = new ArrayList<HttpHeaderPair>();
        HttpHeaderPair httpHeaderPair = HttpUtils.getHeaderPair(CHECKSUM_HEADER, checksum);
        headerPairs.add(httpHeaderPair);
        HttpHeaderPair contentTypeHeaderPair = HttpUtils.getContentTypeHeaderPair();
        headerPairs.add(contentTypeHeaderPair);
        return headerPairs;
    }
}

