package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Data
@NoArgsConstructor
public class SDKConfig {

    @Valid
    @NotNull
    private MerchantConfig merchantConfig;

    @NotNull
    @Valid
    private Endpoint endpoint;

    @Valid
    private HttpClientConfig httpClientConfig = HttpClientConfig.builder().build();

    @Valid
    private InitConfig initConfig = InitConfig.builder().build();

    @Valid
    private StatusConfig statusConfig = StatusConfig.builder().build();

    @Valid
    private HystrixConfig hystrixConfig = HystrixConfig.builder().build();

    @Builder
    @SuppressWarnings("unused")
    public SDKConfig(final MerchantConfig merchantConfig,final HttpClientConfig httpClientConfig,
                     final Endpoint endpoint, final InitConfig initConfig,
                     final StatusConfig statusConfig, final HystrixConfig hystrixConfig){

        this.merchantConfig = merchantConfig;
        this.endpoint = endpoint;
        this.httpClientConfig = httpClientConfig == null ? HttpClientConfig.builder().build() : httpClientConfig;
        this.initConfig = initConfig == null ? InitConfig.builder().build() : initConfig;
        this.statusConfig = statusConfig == null ? StatusConfig.builder().build() : statusConfig;
        this.hystrixConfig = hystrixConfig == null ? HystrixConfig.builder().build() : hystrixConfig;
    }
}
