package com.phonepe.sdk.javasdk.transaction.checksum.payload;

import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import com.phonepe.sdk.javasdk.utils.ChecksumUtils;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;


@NoArgsConstructor
public class ParamsChecksumGenerator implements ChecksumGenerator {

    @Override
    public String getChecksumValue(final PhonePeHttpRequest<?> data,
                                   final String apiURL,
                                   final List<String> otherParams,
                                   final String apiKey,
                                   final int keyIndex) throws PhonePeClientException{

        if(CollectionUtils.isEmpty(otherParams))
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, "Parameter list cannot be empty for params checksum generator");
        StringBuilder checksumPayload = new StringBuilder();
        for (String checksumParam : otherParams)
            checksumPayload.append(checksumParam);
        final String checksumValue = ChecksumUtils.generateChecksumValue(checksumPayload.toString(), apiKey);
        return ChecksumUtils.generateChecksumHeader(checksumValue, keyIndex);
    }
}
