package com.phonepe.sdk.javasdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.InvalidConfigException;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.PhonePeSDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import lombok.Builder;
import lombok.extern.slf4j.Slf4j;
import okhttp3.OkHttpClient;

import javax.validation.Validation;
import javax.validation.Validator;
import java.util.List;
import java.util.Set;

/**
 * Facade that wraps the {@link com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator} and
 * {@link com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler} and
 * {@link com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker} for the
 * user.
 */
@Slf4j
public class PhonePeClient {

    private TransactionInitiator transactionInitiator;

    private CallbackHandler callbackHandler;

    private TransactionStatusChecker statusChecker;

    @Builder
    public PhonePeClient(final PhonePeSDKConfig phonePeSDKConfig)throws InvalidConfigException{
        Preconditions.checkNotNull(phonePeSDKConfig);
        init(phonePeSDKConfig);
    }


    //TODO: Check if this initialisation Process of PhonePeClient can be moved to a Factory Class and
    //TODO: made to return an fully configured object of PhonePeClient.
    public void init(final PhonePeSDKConfig phonePeSDKConfig) throws InvalidConfigException {
        ObjectMapper objectMapper = new ObjectMapper();
        /*
        PhonePeSDKConfig phonePeSDKConfig = new ConfigurationFactory<PhonePeSDKConfig>(PhonePeSDKConfig.class, validator, objectMapper)
                .build();

         */
        HttpClientConfig httpClientConfig = phonePeSDKConfig.getHttpClientConfig();
        StatusConfig statusConfig = phonePeSDKConfig.getStatusConfig();
        MerchantConfig merchantConfig = phonePeSDKConfig.getMerchantConfig();
        InitConfig initConfig = phonePeSDKConfig.getInitConfig();
        HystrixConfig hystrixConfig = phonePeSDKConfig.getHystrixConfig();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig);
        TransactionClient transactionClient = new TransactionClient(httpClientConfig,objectMapper,client, hystrixConfig);
        this.statusChecker  =    TransactionStatusChecker.builder()
                                                      .merchantConfig(merchantConfig)
                                                      .statusConfig(statusConfig)
                                                      .transactionClient(transactionClient)
                                                      .build();

        this.callbackHandler =  CallbackHandler.builder()
                                               .merchantConfig(merchantConfig)
                                               .transactionStatusChecker(this.statusChecker)
                                               .build();
        this.transactionInitiator = WebTransactionInitiator.builder()
                                                           .initConfig(initConfig)
                                                           .merchantConfig(merchantConfig)
                                                           .transactionClient(transactionClient)
                                                           .build();
    }

    public InitResponse initTransaction(final String transactionId,
                                        final Long amount){
        return initTransaction(transactionId, amount, null,null);
    }

    public InitResponse initTransaction(final String transactionId,
                                        final Long amount,
                                        final Set<String> offerTags){
        return initTransaction(transactionId, amount, offerTags,null);
    }

    public InitResponse initTransaction(final String transactionId,
                                        final Long amount,
                                        final List<AllowedAccountConstraint> allowedAccountConstraints){
        return initTransaction(transactionId, amount, null,allowedAccountConstraints);
    }

    public InitResponse initTransaction(final String transactionId,
                                        final Long amount,
                                        final Set<String> offerTags,
                                        final List<AllowedAccountConstraint> allowedAccountConstraints){
        return initTransaction(transactionId, amount, offerTags, allowedAccountConstraints, "", "", "","");
    }


    public InitResponse initTransaction(final String transactionId,
                                        final Long amount,
                                        final Set<String> offerTags,
                                        final List<AllowedAccountConstraint> allowedAccountConstraints,
                                        final String redirectMode,
                                        final String redirectURL,
                                        final String callbackURL,
                                        final String callMode){
        return initTransaction(transactionId, amount, offerTags, allowedAccountConstraints, redirectMode,redirectURL,callMode,callbackURL,1);
    }

    public InitResponse initTransaction(final String transactionId,
                                        final Long amount,
                                        final Set<String> offerTags,
                                        final List<AllowedAccountConstraint> allowedAccountConstraints,
                                        final String redirectMode,
                                        final String redirectURL,
                                        final String callMode,
                                        final String callbackURL,
                                        final int keyIndex){
        return this.transactionInitiator.initiateTransaction(transactionId, amount, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, keyIndex);
    }


    public StatusResponse handleCallback(final String responseReceived, final String checksum){
        return this.callbackHandler.handleCallback(responseReceived, checksum);
    }

    public StatusResponse checkTransactionStatus(final String transactionId){
        return this.statusChecker.checkTransactionStatus(transactionId);
    }

}