package com.phonepe.sdk.javasdk.config.models;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class PhonePeSDKConfig {

    @Valid
    @NotNull
    private MerchantConfig merchantConfig;

    @Valid
    @NotNull
    private HttpClientConfig httpClientConfig;

    @Valid
    @NotNull
    private InitConfig initConfig;

    @Valid
    @NotNull
    private StatusConfig statusConfig;

    private HystrixConfig hystrixConfig = HystrixConfig.builder().build();
}
