/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.InvalidConfigException;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.PhonePeSDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import java.util.List;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;

    public PhonePeClient(PhonePeSDKConfig phonePeSDKConfig) throws InvalidConfigException {
        Preconditions.checkNotNull((Object)phonePeSDKConfig);
        this.init(phonePeSDKConfig);
    }

    public void init(PhonePeSDKConfig phonePeSDKConfig) throws InvalidConfigException {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpClientConfig httpClientConfig = phonePeSDKConfig.getHttpClientConfig();
        StatusConfig statusConfig = phonePeSDKConfig.getStatusConfig();
        MerchantConfig merchantConfig = phonePeSDKConfig.getMerchantConfig();
        InitConfig initConfig = phonePeSDKConfig.getInitConfig();
        HystrixConfig hystrixConfig = phonePeSDKConfig.getHystrixConfig();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig);
        TransactionClient transactionClient = new TransactionClient(httpClientConfig, objectMapper, client, hystrixConfig);
        this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).build();
        this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
        this.transactionInitiator = WebTransactionInitiator.builder().initConfig(initConfig).merchantConfig(merchantConfig).transactionClient(transactionClient).build();
    }

    public InitResponse initTransaction(String transactionId, Long amount) {
        return this.initTransaction(transactionId, amount, null, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags) {
        return this.initTransaction(transactionId, amount, offerTags, null);
    }

    public InitResponse initTransaction(String transactionId, Long amount, List<AllowedAccountConstraint> allowedAccountConstraints) {
        return this.initTransaction(transactionId, amount, null, allowedAccountConstraints);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints) {
        return this.initTransaction(transactionId, amount, offerTags, allowedAccountConstraints, "", "", "", "");
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callbackURL, String callMode) {
        return this.initTransaction(transactionId, amount, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, 1);
    }

    public InitResponse initTransaction(String transactionId, Long amount, Set<String> offerTags, List<AllowedAccountConstraint> allowedAccountConstraints, String redirectMode, String redirectURL, String callMode, String callbackURL, int keyIndex) {
        return this.transactionInitiator.initiateTransaction(transactionId, amount, offerTags, allowedAccountConstraints, redirectMode, redirectURL, callMode, callbackURL, keyIndex);
    }

    public StatusResponse handleCallback(String responseReceived, String checksum) {
        return this.callbackHandler.handleCallback(responseReceived, checksum);
    }

    public StatusResponse checkTransactionStatus(String transactionId) {
        return this.statusChecker.checkTransactionStatus(transactionId);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public static class PhonePeClientBuilder {
        private PhonePeSDKConfig phonePeSDKConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder phonePeSDKConfig(PhonePeSDKConfig phonePeSDKConfig) {
            this.phonePeSDKConfig = phonePeSDKConfig;
            return this;
        }

        public PhonePeClient build() throws InvalidConfigException {
            return new PhonePeClient(this.phonePeSDKConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(phonePeSDKConfig=" + this.phonePeSDKConfig + ")";
        }
    }
}

