package com.phonepe.sdk.javasdk.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpRequest;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

import java.util.List;



@Slf4j
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class HttpPostCommand<T,J> extends BaseHttpCommand<T,J> {

  @Override
  public void preconditions() throws PhonePeClientException {
    super.preconditions();
    Preconditions.checkNotNull(httpRequest, "postData cant be null");
  }

  @Builder
  public HttpPostCommand(OkHttpClient client, HystrixConfig hystrixConfig, String command,
                         Endpoint endpoint, String url,
                         @Singular("header") List<HttpHeaderPair> headers,
                         PhonePeHttpRequest httpRequest, ObjectMapper mapper,
                         Class<T> responseType,
                         Consumer<Exception, T> exceptionConsumer,
                         Consumer<ExtractedResponse, T> nonSuccessResponseConsumer,
                         TypeReference<T> responseTypeReference) {
    super(client, hystrixConfig, command, endpoint, url, headers, httpRequest, mapper, responseType,
          exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
  }


  public Request getRequest(HttpUrl httpUrl) throws JsonProcessingException {
    Request.Builder requestBuilder = new Request.Builder()
            .url(httpUrl)
            .post(getRequestBody());
    buildHeaders(requestBuilder);
    return requestBuilder.build();
  }
}
