/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.SDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGeneratorFactory;
import com.phonepe.sdk.javasdk.transaction.checksum.payload.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiatorFactory;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.models.InitParams;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreatorFactory;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;
    private int defaultKeyIndex;

    public PhonePeClient(SDKConfig sdkConfig) {
        Preconditions.checkNotNull((Object)sdkConfig);
        this.init(sdkConfig);
    }

    private void init(SDKConfig sdkConfig) {
        HttpClientConfig httpClientConfig = sdkConfig.getHttpClientConfig();
        Endpoint endpoint = sdkConfig.getEndpoint();
        StatusConfig statusConfig = sdkConfig.getStatusConfig();
        MerchantConfig merchantConfig = sdkConfig.getMerchantConfig();
        InitConfig initConfig = sdkConfig.getInitConfig();
        HystrixConfig hystrixConfig = sdkConfig.getHystrixConfig();
        ChecksumGeneratorFactory checksumGeneratorFactory = new ChecksumGeneratorFactory();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(httpClientConfig, endpoint.getEnvironment().isSecured());
        TransactionClient transactionClient = new TransactionClient(endpoint, client, hystrixConfig);
        ChecksumGenerator statusChecksumGenerator = statusConfig.getApiVersion().accept(checksumGeneratorFactory);
        ChecksumGenerator initChecksumGenerator = initConfig.getApiVersion().accept(checksumGeneratorFactory);
        PhonePeHttpRequestCreatorFactory phonePeHttpRequestCreatorFactory = new PhonePeHttpRequestCreatorFactory();
        PhonePeHttpRequestCreator phonePeHttpRequestCreator = (PhonePeHttpRequestCreator)initConfig.getApiVersion().accept(phonePeHttpRequestCreatorFactory);
        TransactionInitiatorFactory transactionInitiatorFactory = TransactionInitiatorFactory.builder().merchantConfig(merchantConfig).initConfig(initConfig).transactionClient(transactionClient).checksumGenerator(initChecksumGenerator).phonePeHttpRequestCreator(phonePeHttpRequestCreator).build();
        this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionClient(transactionClient).checksumGenerator(statusChecksumGenerator).build();
        this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
        this.transactionInitiator = initConfig.getInitType().accept(transactionInitiatorFactory);
        this.defaultKeyIndex = KeyUtils.getDefaultKeyIndex(merchantConfig.getApiKeys());
    }

    public InitResponse initTransaction(InitParams initParam) throws PhonePeClientException {
        return this.initTransaction(initParam, this.defaultKeyIndex);
    }

    public InitResponse initTransaction(InitParams initParams, int keyIndex) throws PhonePeClientException {
        return this.transactionInitiator.initiateTransaction(initParams.getTransactionId(), initParams.getAmount(), ObjectUtils.isNotEmpty((Object)initParams.getOrderId()) ? initParams.getOrderId() : initParams.getTransactionId(), initParams.getUserId(), initParams.getSubMerchant(), initParams.getSubMerchantId(), initParams.getMobileNumber(), initParams.getEmailId(), initParams.getShortName(), initParams.getMessage(), initParams.getOfferTags(), initParams.getAllowedAccountConstraints(), initParams.getRedirectMode(), initParams.getRedirectURL(), initParams.getCallbackMode(), initParams.getCallbackURL(), keyIndex);
    }

    public StatusResponse handleCallback(String responseReceived, String checksum, long transactionAmount) throws PhonePeClientException {
        return this.callbackHandler.handleCallback(responseReceived, checksum, transactionAmount);
    }

    public StatusResponse checkTransactionStatus(String transactionId) throws PhonePeClientException {
        return this.checkTransactionStatus(transactionId, this.defaultKeyIndex);
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) throws PhonePeClientException {
        return this.statusChecker.checkTransactionStatus(transactionId, keyIndex);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public static class PhonePeClientBuilder {
        private SDKConfig sdkConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder sdkConfig(SDKConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public PhonePeClient build() {
            return new PhonePeClient(this.sdkConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(sdkConfig=" + this.sdkConfig + ")";
        }
    }
}

