/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HystrixConfig;
import com.phonepe.sdk.javasdk.http.BaseHttpCommand;
import com.phonepe.sdk.javasdk.http.Consumer;
import com.phonepe.sdk.javasdk.http.models.ExtractedResponse;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetCommand<T, J>
extends BaseHttpCommand<T, J> {
    private static final Logger log = LoggerFactory.getLogger(HttpGetCommand.class);

    public HttpGetCommand(OkHttpClient client, HystrixConfig hystrixConfig, String command, Endpoint endpoint, String url, List<HttpHeaderPair> headers, ObjectMapper mapper, Class<T> responseType, Consumer<Exception, T> exceptionConsumer, Consumer<ExtractedResponse, T> nonSuccessResponseConsumer, TypeReference<T> responseTypeReference) {
        super(client, hystrixConfig, command, endpoint, url, headers, null, mapper, responseType, exceptionConsumer, nonSuccessResponseConsumer, responseTypeReference);
    }

    @Override
    public Request getRequest(HttpUrl httpUrl) {
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl).get();
        this.buildHeaders(requestBuilder);
        return requestBuilder.build();
    }

    public static <T, J> HttpGetCommandBuilder<T, J> builder() {
        return new HttpGetCommandBuilder();
    }

    public String toString() {
        return "HttpGetCommand(super=" + super.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpGetCommand)) {
            return false;
        }
        HttpGetCommand other = (HttpGetCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpGetCommand;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class HttpGetCommandBuilder<T, J> {
        private OkHttpClient client;
        private HystrixConfig hystrixConfig;
        private String command;
        private Endpoint endpoint;
        private String url;
        private ArrayList<HttpHeaderPair> headers;
        private ObjectMapper mapper;
        private Class<T> responseType;
        private Consumer<Exception, T> exceptionConsumer;
        private Consumer<ExtractedResponse, T> nonSuccessResponseConsumer;
        private TypeReference<T> responseTypeReference;

        HttpGetCommandBuilder() {
        }

        public HttpGetCommandBuilder<T, J> client(OkHttpClient client) {
            this.client = client;
            return this;
        }

        public HttpGetCommandBuilder<T, J> hystrixConfig(HystrixConfig hystrixConfig) {
            this.hystrixConfig = hystrixConfig;
            return this;
        }

        public HttpGetCommandBuilder<T, J> command(String command) {
            this.command = command;
            return this;
        }

        public HttpGetCommandBuilder<T, J> endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public HttpGetCommandBuilder<T, J> url(String url) {
            this.url = url;
            return this;
        }

        public HttpGetCommandBuilder<T, J> header(HttpHeaderPair header) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.add(header);
            return this;
        }

        public HttpGetCommandBuilder<T, J> headers(Collection<? extends HttpHeaderPair> headers) {
            if (this.headers == null) {
                this.headers = new ArrayList();
            }
            this.headers.addAll(headers);
            return this;
        }

        public HttpGetCommandBuilder<T, J> clearHeaders() {
            if (this.headers != null) {
                this.headers.clear();
            }
            return this;
        }

        public HttpGetCommandBuilder<T, J> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public HttpGetCommandBuilder<T, J> responseType(Class<T> responseType) {
            this.responseType = responseType;
            return this;
        }

        public HttpGetCommandBuilder<T, J> exceptionConsumer(Consumer<Exception, T> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public HttpGetCommandBuilder<T, J> nonSuccessResponseConsumer(Consumer<ExtractedResponse, T> nonSuccessResponseConsumer) {
            this.nonSuccessResponseConsumer = nonSuccessResponseConsumer;
            return this;
        }

        public HttpGetCommandBuilder<T, J> responseTypeReference(TypeReference<T> responseTypeReference) {
            this.responseTypeReference = responseTypeReference;
            return this;
        }

        public HttpGetCommand<T, J> build() {
            List<HttpHeaderPair> headers;
            switch (this.headers == null ? 0 : this.headers.size()) {
                case 0: {
                    headers = Collections.emptyList();
                    break;
                }
                case 1: {
                    headers = Collections.singletonList(this.headers.get(0));
                    break;
                }
                default: {
                    headers = Collections.unmodifiableList(new ArrayList<HttpHeaderPair>(this.headers));
                }
            }
            return new HttpGetCommand(this.client, this.hystrixConfig, this.command, this.endpoint, this.url, headers, this.mapper, this.responseType, this.exceptionConsumer, this.nonSuccessResponseConsumer, this.responseTypeReference);
        }

        public String toString() {
            return "HttpGetCommand.HttpGetCommandBuilder(client=" + this.client + ", hystrixConfig=" + this.hystrixConfig + ", command=" + this.command + ", endpoint=" + this.endpoint + ", url=" + this.url + ", headers=" + this.headers + ", mapper=" + this.mapper + ", responseType=" + this.responseType + ", exceptionConsumer=" + this.exceptionConsumer + ", nonSuccessResponseConsumer=" + this.nonSuccessResponseConsumer + ", responseTypeReference=" + this.responseTypeReference + ")";
        }
    }
}

