/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init.decorator;

import com.phonepe.sdk.javasdk.transaction.init.decorator.InitRequestDecorator;
import com.phonepe.sdk.javasdk.transaction.init.decorator.TransactionInitComponent;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferContext;
import com.phonepe.sdk.javasdk.transaction.init.models.OfferTag;
import java.util.HashSet;
import java.util.Set;

public class OfferInitDecorator
extends InitRequestDecorator {
    private Set<String> offerTagIds;

    public OfferInitDecorator(TransactionInitComponent transactionInitComponent, Set<String> offerTagIds) {
        super(transactionInitComponent);
        this.offerTagIds = offerTagIds;
    }

    @Override
    public InitRequest getInitRequest() {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest();
        Set<OfferTag> offerTagSet = this.getOfferTags(initRequest.getAmount());
        OfferContext offerContext = OfferContext.builder().tags(offerTagSet).build();
        MerchantContext merchantContext = initRequest.getMerchantContext();
        if (merchantContext != null) {
            merchantContext.setOfferContext(offerContext);
        } else {
            merchantContext = MerchantContext.builder().offerContext(offerContext).build();
        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }

    private Set<OfferTag> getOfferTags(Long amount) {
        HashSet<OfferTag> offerTags = new HashSet<OfferTag>();
        for (String tagId : this.offerTagIds) {
            offerTags.add(OfferTag.builder().id(tagId).amount(amount).build());
        }
        return offerTags;
    }

    public static OfferInitDecoratorBuilder builder() {
        return new OfferInitDecoratorBuilder();
    }

    @Override
    public String toString() {
        return "OfferInitDecorator(super=" + super.toString() + ", offerTagIds=" + this.offerTagIds + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfferInitDecorator)) {
            return false;
        }
        OfferInitDecorator other = (OfferInitDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<String> this$offerTagIds = this.offerTagIds;
        Set<String> other$offerTagIds = other.offerTagIds;
        return !(this$offerTagIds == null ? other$offerTagIds != null : !((Object)this$offerTagIds).equals(other$offerTagIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OfferInitDecorator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<String> $offerTagIds = this.offerTagIds;
        result = result * 59 + ($offerTagIds == null ? 43 : ((Object)$offerTagIds).hashCode());
        return result;
    }

    public static class OfferInitDecoratorBuilder {
        private TransactionInitComponent transactionInitComponent;
        private Set<String> offerTagIds;

        OfferInitDecoratorBuilder() {
        }

        public OfferInitDecoratorBuilder transactionInitComponent(TransactionInitComponent transactionInitComponent) {
            this.transactionInitComponent = transactionInitComponent;
            return this;
        }

        public OfferInitDecoratorBuilder offerTagIds(Set<String> offerTagIds) {
            this.offerTagIds = offerTagIds;
            return this;
        }

        public OfferInitDecorator build() {
            return new OfferInitDecorator(this.transactionInitComponent, this.offerTagIds);
        }

        public String toString() {
            return "OfferInitDecorator.OfferInitDecoratorBuilder(transactionInitComponent=" + this.transactionInitComponent + ", offerTagIds=" + this.offerTagIds + ")";
        }
    }
}

