package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class HystrixConfig {

    private ThreadPool threadPool = ThreadPool.builder().build();

    private Metrics metrics = Metrics.builder().build();

    private CircuitBreaker circuitBreaker = CircuitBreaker.builder().build();

    @Builder
    @SuppressWarnings("unused")
    public HystrixConfig(final ThreadPool threadPool, final Metrics metrics, final CircuitBreaker circuitBreaker){
        this.threadPool = threadPool == null ? ThreadPool.builder().build() : threadPool;
        this.metrics = metrics == null ? Metrics.builder().build() : metrics;
        this.circuitBreaker = circuitBreaker == null ? CircuitBreaker.builder().build() : circuitBreaker;
    }
}
