/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.ConstraintViolation;

public class PhonePeConfigurationException
extends Exception {
    private static final long serialVersionUID = 5325162099634227047L;

    public PhonePeConfigurationException(String path, String message) {
        super(PhonePeConfigurationException.formatMessage(path, Collections.singletonList(message)));
    }

    public <T> PhonePeConfigurationException(String path, Set<ConstraintViolation<T>> errors) {
        super(PhonePeConfigurationException.formatMessage(path, PhonePeConfigurationException.format(errors)));
    }

    public static <T> Collection<String> format(Set<ConstraintViolation<T>> violations) {
        TreeSet<String> errors = new TreeSet<String>();
        for (ConstraintViolation<T> v : violations) {
            errors.add(PhonePeConfigurationException.format(v));
        }
        return errors;
    }

    public static <T> String format(ConstraintViolation<T> v) {
        return String.format("%s %s", v.getPropertyPath(), v.getMessage());
    }

    private static String formatMessage(String file, Iterable<String> errors) {
        StringBuilder msg = new StringBuilder(file).append(" has the following errors:\n");
        for (String error : errors) {
            msg.append("  * ").append(error).append('\n');
        }
        return msg.toString();
    }
}

