/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.http.models.HttpHeaderPair;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.CallbackMode;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.RedirectMode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    public static final String APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHECKSUM_HEADER = "X-VERIFY";
    public static final String LOCATION_HEADER = "location";
    public static final String PROVIDER_ID_HEADER = "X-PROVIDER-ID";
    public static final String REDIRECT_URL_HEADER = "X-REDIRECT-URL";
    public static final String REDIRECT_MODE_HEADER = "X-REDIRECT-MODE";
    public static final String CALLBACK_URL_HEADER = "X-CALLBACK-URL";
    public static final String CALL_MODE_HEADER = "X-CALL-MODE";
    public static final String V1_DEBIT_URL = "/v1/debit";
    public static final String V3_DEBIT_URL = "/v3/debit";

    private HttpUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] body(Response response) throws IOException {
        ResponseBody body = response.body();
        if (ObjectUtils.anyNotNull((Object[])new Object[]{body})) {
            return body.bytes();
        }
        return new byte[0];
    }

    public static HttpHeaderPair getHeaderPair(String name, String value) {
        return HttpHeaderPair.builder().name(name).value(value).build();
    }

    public static HttpHeaderPair getContentTypeHeaderPair() {
        return HttpUtils.getHeaderPair(CONTENT_TYPE, APPLICATION_JSON);
    }

    public static <T1, T2> void checkNotNull(T1 t, T2 t2, String message) throws PhonePeClientException {
        if (t == null && t2 == null) {
            throw new PhonePeClientException(PhonePeClientException.ErrorCode.VALIDATION_ERROR, message);
        }
    }

    public static List<HttpHeaderPair> getHttpHeaders(String checksum, String providerId, String redirectURL, RedirectMode redirectMode, String callbackURL, CallbackMode callMode) {
        Preconditions.checkNotNull((Object)checksum);
        List<HttpHeaderPair> headerPairs = HttpUtils.getHttpHeaders(checksum);
        if (!Strings.isNullOrEmpty((String)providerId)) {
            HttpHeaderPair providerIdHeader = HttpUtils.getHeaderPair(PROVIDER_ID_HEADER, providerId);
            headerPairs.add(providerIdHeader);
        }
        if (!Strings.isNullOrEmpty((String)redirectURL)) {
            HttpHeaderPair redirectURLHeader = HttpUtils.getHeaderPair(REDIRECT_URL_HEADER, redirectURL);
            headerPairs.add(redirectURLHeader);
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{redirectMode})) {
            HttpHeaderPair redirectModeHeader = HttpUtils.getHeaderPair(REDIRECT_MODE_HEADER, redirectMode.getValue());
            headerPairs.add(redirectModeHeader);
        }
        if (!Strings.isNullOrEmpty((String)callbackURL)) {
            HttpHeaderPair callbackURLHeader = HttpUtils.getHeaderPair(CALLBACK_URL_HEADER, callbackURL);
            headerPairs.add(callbackURLHeader);
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{callMode})) {
            HttpHeaderPair callbackModeHeader = HttpUtils.getHeaderPair(CALL_MODE_HEADER, callMode.getValue());
            headerPairs.add(callbackModeHeader);
        }
        return headerPairs;
    }

    public static List<HttpHeaderPair> getHttpHeaders(String checksum) {
        ArrayList<HttpHeaderPair> headerPairs = new ArrayList<HttpHeaderPair>();
        HttpHeaderPair httpHeaderPair = HttpUtils.getHeaderPair(CHECKSUM_HEADER, checksum);
        headerPairs.add(httpHeaderPair);
        HttpHeaderPair contentTypeHeaderPair = HttpUtils.getContentTypeHeaderPair();
        headerPairs.add(contentTypeHeaderPair);
        return headerPairs;
    }
}

