/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import com.google.common.base.Strings;
import com.phonepe.sdk.javasdk.config.models.enums.Environment;
import java.net.URI;
import javax.validation.constraints.NotNull;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.ObjectUtils;

public class Endpoint {
    @NotNull
    private Environment environment;
    private String overrideHost;
    private Boolean overrideSecured;

    public Endpoint(@NotNull Environment environment, String overrideHost, Boolean overrideSecured) {
        this.environment = environment;
        if (!Strings.isNullOrEmpty((String)overrideHost)) {
            this.overrideHost = overrideHost;
            this.environment.setHost(overrideHost);
        }
        if (ObjectUtils.anyNotNull((Object[])new Object[]{overrideSecured})) {
            this.overrideSecured = overrideSecured;
            this.environment.setSecured(overrideSecured);
        }
    }

    public HttpUrl getUrl(String path) {
        String protocol = this.environment.isSecured() ? "https" : "http";
        return HttpUrl.get((URI)URI.create(String.format("%s://%s%s", protocol, this.environment.getHost(), path)));
    }

    public static EndpointBuilder builder() {
        return new EndpointBuilder();
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getOverrideHost() {
        return this.overrideHost;
    }

    public Boolean getOverrideSecured() {
        return this.overrideSecured;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setOverrideHost(String overrideHost) {
        this.overrideHost = overrideHost;
    }

    public void setOverrideSecured(Boolean overrideSecured) {
        this.overrideSecured = overrideSecured;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)((Object)this$environment)).equals((Object)other$environment)) {
            return false;
        }
        String this$overrideHost = this.getOverrideHost();
        String other$overrideHost = other.getOverrideHost();
        if (this$overrideHost == null ? other$overrideHost != null : !this$overrideHost.equals(other$overrideHost)) {
            return false;
        }
        Boolean this$overrideSecured = this.getOverrideSecured();
        Boolean other$overrideSecured = other.getOverrideSecured();
        return !(this$overrideSecured == null ? other$overrideSecured != null : !((Object)this$overrideSecured).equals(other$overrideSecured));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)((Object)$environment)).hashCode());
        String $overrideHost = this.getOverrideHost();
        result = result * 59 + ($overrideHost == null ? 43 : $overrideHost.hashCode());
        Boolean $overrideSecured = this.getOverrideSecured();
        result = result * 59 + ($overrideSecured == null ? 43 : ((Object)$overrideSecured).hashCode());
        return result;
    }

    public String toString() {
        return "Endpoint(environment=" + (Object)((Object)this.getEnvironment()) + ", overrideHost=" + this.getOverrideHost() + ", overrideSecured=" + this.getOverrideSecured() + ")";
    }

    public Endpoint() {
    }

    public static class EndpointBuilder {
        private Environment environment;
        private String overrideHost;
        private Boolean overrideSecured;

        EndpointBuilder() {
        }

        public EndpointBuilder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public EndpointBuilder overrideHost(String overrideHost) {
            this.overrideHost = overrideHost;
            return this;
        }

        public EndpointBuilder overrideSecured(Boolean overrideSecured) {
            this.overrideSecured = overrideSecured;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this.environment, this.overrideHost, this.overrideSecured);
        }

        public String toString() {
            return "Endpoint.EndpointBuilder(environment=" + (Object)((Object)this.environment) + ", overrideHost=" + this.overrideHost + ", overrideSecured=" + this.overrideSecured + ")";
        }
    }
}

