/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.enums.InitType;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionClient;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;

public class TransactionInitiatorFactory
implements InitType.InitTypeVisitor<TransactionInitiator> {
    private MerchantConfig merchantConfig;
    private InitConfig initConfig;
    private TransactionClient transactionClient;
    private ChecksumGenerator checksumGenerator;
    private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

    @Override
    public TransactionInitiator visitWeb() {
        return WebTransactionInitiator.builder().phonePeHttpRequestCreator(this.phonePeHttpRequestCreator).checksumGenerator(this.checksumGenerator).transactionClient(this.transactionClient).merchantConfig(this.merchantConfig).initConfig(this.initConfig).build();
    }

    @Override
    public TransactionInitiator visitIntent() {
        return null;
    }

    public static TransactionInitiatorFactoryBuilder builder() {
        return new TransactionInitiatorFactoryBuilder();
    }

    public TransactionInitiatorFactory(MerchantConfig merchantConfig, InitConfig initConfig, TransactionClient transactionClient, ChecksumGenerator checksumGenerator, PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.merchantConfig = merchantConfig;
        this.initConfig = initConfig;
        this.transactionClient = transactionClient;
        this.checksumGenerator = checksumGenerator;
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
    }

    public static class TransactionInitiatorFactoryBuilder {
        private MerchantConfig merchantConfig;
        private InitConfig initConfig;
        private TransactionClient transactionClient;
        private ChecksumGenerator checksumGenerator;
        private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

        TransactionInitiatorFactoryBuilder() {
        }

        public TransactionInitiatorFactoryBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public TransactionInitiatorFactoryBuilder initConfig(InitConfig initConfig) {
            this.initConfig = initConfig;
            return this;
        }

        public TransactionInitiatorFactoryBuilder transactionClient(TransactionClient transactionClient) {
            this.transactionClient = transactionClient;
            return this;
        }

        public TransactionInitiatorFactoryBuilder checksumGenerator(ChecksumGenerator checksumGenerator) {
            this.checksumGenerator = checksumGenerator;
            return this;
        }

        public TransactionInitiatorFactoryBuilder phonePeHttpRequestCreator(PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
            this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
            return this;
        }

        public TransactionInitiatorFactory build() {
            return new TransactionInitiatorFactory(this.merchantConfig, this.initConfig, this.transactionClient, this.checksumGenerator, this.phonePeHttpRequestCreator);
        }

        public String toString() {
            return "TransactionInitiatorFactory.TransactionInitiatorFactoryBuilder(merchantConfig=" + this.merchantConfig + ", initConfig=" + this.initConfig + ", transactionClient=" + this.transactionClient + ", checksumGenerator=" + this.checksumGenerator + ", phonePeHttpRequestCreator=" + this.phonePeHttpRequestCreator + ")";
        }
    }
}

