package com.phonepe.sdk.javasdk.config.models;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Data
@NoArgsConstructor
public class SDKConfig {

    @Valid
    @NotNull
    private MerchantConfig merchantConfig;

    @Valid
    private PhonePeConfig phonePeConfig = PhonePeConfig
            .builder()
            .build();

    @Builder
    @SuppressWarnings("unused")
    public SDKConfig(final MerchantConfig merchantConfig,
                     final PhonePeConfig phonePeConfig) {

        this.merchantConfig = merchantConfig;
        this.phonePeConfig = phonePeConfig == null
                             ? PhonePeConfig
                                     .builder()
                                     .build()
                             : phonePeConfig;
    }
}
