package com.phonepe.sdk.javasdk.config.models.enums;


public enum Environment {

    UAT {
        @Override
        public <T> T accept(Environment.EnvironmentVisitor<T> visitor) {
            return visitor.visitUat();
        }
    }, PRODUCTION {
        @Override
        public <T> T accept(Environment.EnvironmentVisitor<T> visitor) {
            return visitor.visitProduction();
        }
    };

    public abstract <T> T accept(Environment.EnvironmentVisitor<T> visitor);

    public interface EnvironmentVisitor<T> {
        T visitUat();

        T visitProduction();
    }
}
