package com.phonepe.sdk.javasdk.transaction.status.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class TransactionStatusResponse {

    private String merchantId;
    private String transactionId;
    private String providerReferenceId;
    private Long amount;
    private String paymentState;
    private String payResponseCode;
    private Long paidAmount;
    private List<Map<String, Object>> paymentModes;
    private TransactionContext transactionContext;
}
