package com.phonepe.sdk.javasdk.utils;

import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;


@Slf4j
@UtilityClass
public class ChecksumUtils {

    private static final String SEPARATOR_VALUE = "###";

    public static String generateChecksumHeader(final String checksumValue,
                                                final int apiKeyIndex) {
        return checksumValue
                .concat(SEPARATOR_VALUE)
                .concat(Integer.toString(apiKeyIndex));
    }

    public static String generateChecksumValue(final String checksumPayload,
                                               final String apiKey) {
        String hex = checksumPayload.concat(apiKey);
        return DigestUtils.sha256Hex(hex);
    }
}
