/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import okhttp3.ConnectionSpec;
import okhttp3.TlsVersion;
import okhttp3.logging.HttpLoggingInterceptor;

public class HttpClientConfig {
    @Min(value=10L)
    @Max(value=1024L)
    private int connections = 10;
    @Max(value=86400L)
    private int idleTimeOutSeconds = 30;
    @Max(value=86400000L)
    private int connectTimeoutMs = 10000;
    @Max(value=86400000L)
    private int opTimeoutMs = 10000;
    private TlsVersion tlsVersion = TlsVersion.TLS_1_2;
    private ConnectionSpec connectionSpec = ConnectionSpec.MODERN_TLS;
    private HttpLoggingInterceptor.Level loggingLevel = HttpLoggingInterceptor.Level.NONE;

    public HttpClientConfig(@Min(value=10L) @Max(value=1024L) int connections, @Max(value=86400L) int idleTimeOutSeconds, @Max(value=86400000L) int connectTimeoutMs, @Max(value=86400000L) int opTimeoutMs, TlsVersion tlsVersion, ConnectionSpec connectionSpec, HttpLoggingInterceptor.Level loggingLevel) {
        this.connections = connections == 0 ? 10 : connections;
        this.idleTimeOutSeconds = idleTimeOutSeconds == 0 ? 30 : idleTimeOutSeconds;
        this.connectTimeoutMs = connectTimeoutMs == 0 ? 10000 : connectTimeoutMs;
        this.opTimeoutMs = opTimeoutMs == 0 ? 10000 : opTimeoutMs;
        this.connectionSpec = connectionSpec == null ? ConnectionSpec.MODERN_TLS : connectionSpec;
        this.tlsVersion = tlsVersion == null ? TlsVersion.TLS_1_2 : tlsVersion;
        this.loggingLevel = loggingLevel == null ? HttpLoggingInterceptor.Level.NONE : loggingLevel;
    }

    public static HttpClientConfigBuilder builder() {
        return new HttpClientConfigBuilder();
    }

    public int getConnections() {
        return this.connections;
    }

    public int getIdleTimeOutSeconds() {
        return this.idleTimeOutSeconds;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getOpTimeoutMs() {
        return this.opTimeoutMs;
    }

    public TlsVersion getTlsVersion() {
        return this.tlsVersion;
    }

    public ConnectionSpec getConnectionSpec() {
        return this.connectionSpec;
    }

    public HttpLoggingInterceptor.Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setConnections(int connections) {
        this.connections = connections;
    }

    public void setIdleTimeOutSeconds(int idleTimeOutSeconds) {
        this.idleTimeOutSeconds = idleTimeOutSeconds;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setOpTimeoutMs(int opTimeoutMs) {
        this.opTimeoutMs = opTimeoutMs;
    }

    public void setTlsVersion(TlsVersion tlsVersion) {
        this.tlsVersion = tlsVersion;
    }

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public void setLoggingLevel(HttpLoggingInterceptor.Level loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfig)) {
            return false;
        }
        HttpClientConfig other = (HttpClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnections() != other.getConnections()) {
            return false;
        }
        if (this.getIdleTimeOutSeconds() != other.getIdleTimeOutSeconds()) {
            return false;
        }
        if (this.getConnectTimeoutMs() != other.getConnectTimeoutMs()) {
            return false;
        }
        if (this.getOpTimeoutMs() != other.getOpTimeoutMs()) {
            return false;
        }
        TlsVersion this$tlsVersion = this.getTlsVersion();
        TlsVersion other$tlsVersion = other.getTlsVersion();
        if (this$tlsVersion == null ? other$tlsVersion != null : !this$tlsVersion.equals(other$tlsVersion)) {
            return false;
        }
        ConnectionSpec this$connectionSpec = this.getConnectionSpec();
        ConnectionSpec other$connectionSpec = other.getConnectionSpec();
        if (this$connectionSpec == null ? other$connectionSpec != null : !this$connectionSpec.equals(other$connectionSpec)) {
            return false;
        }
        HttpLoggingInterceptor.Level this$loggingLevel = this.getLoggingLevel();
        HttpLoggingInterceptor.Level other$loggingLevel = other.getLoggingLevel();
        return !(this$loggingLevel == null ? other$loggingLevel != null : !this$loggingLevel.equals(other$loggingLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnections();
        result = result * 59 + this.getIdleTimeOutSeconds();
        result = result * 59 + this.getConnectTimeoutMs();
        result = result * 59 + this.getOpTimeoutMs();
        TlsVersion $tlsVersion = this.getTlsVersion();
        result = result * 59 + ($tlsVersion == null ? 43 : $tlsVersion.hashCode());
        ConnectionSpec $connectionSpec = this.getConnectionSpec();
        result = result * 59 + ($connectionSpec == null ? 43 : $connectionSpec.hashCode());
        HttpLoggingInterceptor.Level $loggingLevel = this.getLoggingLevel();
        result = result * 59 + ($loggingLevel == null ? 43 : $loggingLevel.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientConfig(connections=" + this.getConnections() + ", idleTimeOutSeconds=" + this.getIdleTimeOutSeconds() + ", connectTimeoutMs=" + this.getConnectTimeoutMs() + ", opTimeoutMs=" + this.getOpTimeoutMs() + ", tlsVersion=" + this.getTlsVersion() + ", connectionSpec=" + this.getConnectionSpec() + ", loggingLevel=" + this.getLoggingLevel() + ")";
    }

    public HttpClientConfig() {
    }

    public static class HttpClientConfigBuilder {
        private int connections;
        private int idleTimeOutSeconds;
        private int connectTimeoutMs;
        private int opTimeoutMs;
        private TlsVersion tlsVersion;
        private ConnectionSpec connectionSpec;
        private HttpLoggingInterceptor.Level loggingLevel;

        HttpClientConfigBuilder() {
        }

        public HttpClientConfigBuilder connections(int connections) {
            this.connections = connections;
            return this;
        }

        public HttpClientConfigBuilder idleTimeOutSeconds(int idleTimeOutSeconds) {
            this.idleTimeOutSeconds = idleTimeOutSeconds;
            return this;
        }

        public HttpClientConfigBuilder connectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
            return this;
        }

        public HttpClientConfigBuilder opTimeoutMs(int opTimeoutMs) {
            this.opTimeoutMs = opTimeoutMs;
            return this;
        }

        public HttpClientConfigBuilder tlsVersion(TlsVersion tlsVersion) {
            this.tlsVersion = tlsVersion;
            return this;
        }

        public HttpClientConfigBuilder connectionSpec(ConnectionSpec connectionSpec) {
            this.connectionSpec = connectionSpec;
            return this;
        }

        public HttpClientConfigBuilder loggingLevel(HttpLoggingInterceptor.Level loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.connections, this.idleTimeOutSeconds, this.connectTimeoutMs, this.opTimeoutMs, this.tlsVersion, this.connectionSpec, this.loggingLevel);
        }

        public String toString() {
            return "HttpClientConfig.HttpClientConfigBuilder(connections=" + this.connections + ", idleTimeOutSeconds=" + this.idleTimeOutSeconds + ", connectTimeoutMs=" + this.connectTimeoutMs + ", opTimeoutMs=" + this.opTimeoutMs + ", tlsVersion=" + this.tlsVersion + ", connectionSpec=" + this.connectionSpec + ", loggingLevel=" + this.loggingLevel + ")";
        }
    }
}

