/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.http;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.http.models.PhonePeHttpResponse;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.init.models.enums.RedirectType;
import com.phonepe.sdk.javasdk.utils.MapperUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(PhonePeHttpClientFactory.class);

    private PhonePeHttpClientFactory() {
        throw new IllegalStateException("Factory class");
    }

    public static OkHttpClient buildOkHttpClient(OkHttpClient okHttpClient, HttpClientConfig httpClientConfig, boolean isSecured) {
        Preconditions.checkNotNull((Object)httpClientConfig);
        return okHttpClient == null ? PhonePeHttpClientFactory.createClient(httpClientConfig, isSecured) : PhonePeHttpClientFactory.customiseClient(okHttpClient, httpClientConfig);
    }

    private static OkHttpClient createClient(HttpClientConfig httpClientConfig, boolean isSecured) {
        int connections = httpClientConfig.getConnections();
        int idleTimeOutSeconds = httpClientConfig.getIdleTimeOutSeconds();
        int connTimeout = httpClientConfig.getConnectTimeoutMs();
        int opTimeout = httpClientConfig.getOpTimeoutMs();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(connections);
        dispatcher.setMaxRequestsPerHost(connections);
        ConnectionSpec.Builder connectionSpecBuilder = new ConnectionSpec.Builder(httpClientConfig.getConnectionSpec());
        connectionSpecBuilder.tlsVersions(new TlsVersion[]{httpClientConfig.getTlsVersion()});
        connectionSpecBuilder.allEnabledCipherSuites();
        ConnectionSpec connectionSpec = isSecured ? connectionSpecBuilder.build() : null;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addNetworkInterceptor(PhonePeHttpClientFactory.debitRedirectHandler()).addNetworkInterceptor(PhonePeHttpClientFactory.loggingInterceptor(httpClientConfig.getLoggingLevel())).followRedirects(false).followSslRedirects(false).retryOnConnectionFailure(true).connectionPool(new ConnectionPool(connections, (long)idleTimeOutSeconds, TimeUnit.SECONDS)).connectTimeout((long)connTimeout, TimeUnit.MILLISECONDS).readTimeout((long)opTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)opTimeout, TimeUnit.MILLISECONDS).dispatcher(dispatcher);
        if (connectionSpec != null) {
            clientBuilder.connectionSpecs(Collections.singletonList(connectionSpec));
        }
        clientBuilder.hostnameVerifier((HostnameVerifier)OkHostnameVerifier.INSTANCE);
        return clientBuilder.build();
    }

    private static Interceptor debitRedirectHandler() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                String requestPath = request.url().url().getPath();
                if (response.isRedirect() && (requestPath.contains("/v1/debit") || requestPath.contains("/v3/debit"))) {
                    InitResponse initResponse = InitResponse.builder().redirectType(RedirectType.WEB).redirectURL(response.header("location")).build();
                    PhonePeHttpResponse<InitResponse> phonePeHttpResponse = PhonePeHttpResponse.builder().success(true).message("SUCCESS").code("200").data(initResponse).build();
                    return response.newBuilder().body(ResponseBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])MapperUtils.getMapper().writeValueAsBytes(phonePeHttpResponse))).code(200).build();
                }
                return response;
            }
        };
    }

    private static OkHttpClient customiseClient(OkHttpClient okHttpClient, HttpClientConfig clientConfig) {
        for (Interceptor interceptor : okHttpClient.networkInterceptors()) {
            if (!(interceptor instanceof HttpLoggingInterceptor)) continue;
            return okHttpClient;
        }
        return okHttpClient.newBuilder().addNetworkInterceptor(PhonePeHttpClientFactory.loggingInterceptor(clientConfig.getLoggingLevel())).build();
    }

    private static Interceptor loggingInterceptor(HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(level);
        return loggingInterceptor;
    }
}

