/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.transaction.init;

import com.phonepe.sdk.javasdk.config.URLCreator;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.enums.InitType;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.client.TransactionCommand;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.web.WebTransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;

public class TransactionInitiatorFactory
implements InitType.InitTypeVisitor<TransactionInitiator> {
    private MerchantConfig merchantConfig;
    private InitConfig initConfig;
    private TransactionCommand transactionCommand;
    private ChecksumGenerator checksumGenerator;
    private URLCreator urlCreator;
    private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

    @Override
    public TransactionInitiator visitWeb() {
        return WebTransactionInitiator.builder().phonePeHttpRequestCreator(this.phonePeHttpRequestCreator).checksumGenerator(this.checksumGenerator).transactionCommand(this.transactionCommand).merchantConfig(this.merchantConfig).initConfig(this.initConfig).urlCreator(this.urlCreator).build();
    }

    @Override
    public TransactionInitiator visitIntent() {
        return null;
    }

    public static TransactionInitiatorFactoryBuilder builder() {
        return new TransactionInitiatorFactoryBuilder();
    }

    public TransactionInitiatorFactory(MerchantConfig merchantConfig, InitConfig initConfig, TransactionCommand transactionCommand, ChecksumGenerator checksumGenerator, URLCreator urlCreator, PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
        this.merchantConfig = merchantConfig;
        this.initConfig = initConfig;
        this.transactionCommand = transactionCommand;
        this.checksumGenerator = checksumGenerator;
        this.urlCreator = urlCreator;
        this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
    }

    public static class TransactionInitiatorFactoryBuilder {
        private MerchantConfig merchantConfig;
        private InitConfig initConfig;
        private TransactionCommand transactionCommand;
        private ChecksumGenerator checksumGenerator;
        private URLCreator urlCreator;
        private PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator;

        TransactionInitiatorFactoryBuilder() {
        }

        public TransactionInitiatorFactoryBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public TransactionInitiatorFactoryBuilder initConfig(InitConfig initConfig) {
            this.initConfig = initConfig;
            return this;
        }

        public TransactionInitiatorFactoryBuilder transactionCommand(TransactionCommand transactionCommand) {
            this.transactionCommand = transactionCommand;
            return this;
        }

        public TransactionInitiatorFactoryBuilder checksumGenerator(ChecksumGenerator checksumGenerator) {
            this.checksumGenerator = checksumGenerator;
            return this;
        }

        public TransactionInitiatorFactoryBuilder urlCreator(URLCreator urlCreator) {
            this.urlCreator = urlCreator;
            return this;
        }

        public TransactionInitiatorFactoryBuilder phonePeHttpRequestCreator(PhonePeHttpRequestCreator<InitRequest> phonePeHttpRequestCreator) {
            this.phonePeHttpRequestCreator = phonePeHttpRequestCreator;
            return this;
        }

        public TransactionInitiatorFactory build() {
            return new TransactionInitiatorFactory(this.merchantConfig, this.initConfig, this.transactionCommand, this.checksumGenerator, this.urlCreator, this.phonePeHttpRequestCreator);
        }

        public String toString() {
            return "TransactionInitiatorFactory.TransactionInitiatorFactoryBuilder(merchantConfig=" + this.merchantConfig + ", initConfig=" + this.initConfig + ", transactionCommand=" + this.transactionCommand + ", checksumGenerator=" + this.checksumGenerator + ", urlCreator=" + this.urlCreator + ", phonePeHttpRequestCreator=" + this.phonePeHttpRequestCreator + ")";
        }
    }
}

